/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.ontology;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SrampOntology {
    private String uuid;
    private String label;
    private String comment;
    private String base;
    private String id;
    private String createdBy;
    private Date createdOn;
    private String lastModifiedBy;
    private Date lastModifiedOn;
    private List<SrampOntologyClass> rootClasses = new ArrayList<SrampOntologyClass>();
    private Map<URI, SrampOntologyClass> classIndexByUri = new HashMap<URI, SrampOntologyClass>();
    private Map<String, SrampOntologyClass> classIndexById = new HashMap<String, SrampOntologyClass>();

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String base) {
        this.base = base;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<SrampOntologyClass> getRootClasses() {
        return this.rootClasses;
    }

    public List<SrampOntologyClass> getAllClasses() {
        ArrayList<SrampOntologyClass> allClasses = new ArrayList<SrampOntologyClass>();
        this.addAllClasses(allClasses, this.getRootClasses());
        return allClasses;
    }

    private void addAllClasses(List<SrampOntologyClass> allClasses, List<SrampOntologyClass> classes) {
        allClasses.addAll(classes);
        for (SrampOntologyClass c : classes) {
            this.addAllClasses(allClasses, c.getChildren());
        }
    }

    public void setRootClasses(List<SrampOntologyClass> rootClasses) {
        this.rootClasses = rootClasses;
    }

    public SrampOntologyClass createClass(String id) {
        SrampOntologyClass c = new SrampOntologyClass();
        c.setId(id);
        String uri = this.getBase() + "#" + id;
        try {
            c.setUri(new URI(uri));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return c;
    }

    public synchronized SrampOntologyClass findClass(String id) {
        SrampOntologyClass candidate;
        if (this.classIndexById.containsKey(id)) {
            return this.classIndexById.get(id);
        }
        SrampOntologyClass found = null;
        Iterator<SrampOntologyClass> i$ = this.rootClasses.iterator();
        while (i$.hasNext() && (found = (candidate = i$.next()).findClass(id)) == null) {
        }
        if (found != null) {
            this.classIndexById.put(id, found);
        }
        return found;
    }

    public synchronized SrampOntologyClass findClass(URI uri) {
        SrampOntologyClass candidate;
        if (this.classIndexByUri.containsKey(uri)) {
            return this.classIndexByUri.get(uri);
        }
        SrampOntologyClass found = null;
        Iterator<SrampOntologyClass> i$ = this.rootClasses.iterator();
        while (i$.hasNext() && (found = (candidate = i$.next()).findClass(uri)) == null) {
        }
        if (found != null) {
            this.classIndexByUri.put(uri, found);
        }
        return found;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public void setLastModifiedOn(Date lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public static class SrampOntologyClass {
        private String id;
        private String label;
        private String comment;
        private URI uri;
        private SrampOntologyClass parent;
        private List<SrampOntologyClass> children = new ArrayList<SrampOntologyClass>();

        public SrampOntologyClass findClass(String id) {
            if (this.id.equals(id)) {
                return this;
            }
            for (SrampOntologyClass c : this.children) {
                SrampOntologyClass found = c.findClass(id);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        public SrampOntologyClass findClass(URI uri) {
            if (this.uri.equals(uri)) {
                return this;
            }
            for (SrampOntologyClass c : this.children) {
                SrampOntologyClass found = c.findClass(uri);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        public SrampOntologyClass getParent() {
            return this.parent;
        }

        public void setParent(SrampOntologyClass parent) {
            this.parent = parent;
        }

        public List<SrampOntologyClass> getChildren() {
            return this.children;
        }

        public void setChildren(List<SrampOntologyClass> children) {
            this.children = children;
        }

        public URI getUri() {
            return this.uri;
        }

        public void setUri(URI uri) {
            this.uri = uri;
        }

        public Set<URI> normalize() {
            HashSet<URI> uris = new HashSet<URI>();
            for (SrampOntologyClass current = this; current != null; current = current.getParent()) {
                uris.add(current.getUri());
            }
            return uris;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }
}

