/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.derived;

import java.util.Collection;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Binding;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BindingTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Fault;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.MessageTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationInput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.OperationOutput;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Part;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Port;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.PortTypeTarget;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdTypeTarget;
import org.overlord.sramp.common.ArtifactTypeEnum;
import org.overlord.sramp.common.derived.LinkerContext;
import org.overlord.sramp.common.derived.WsdlDeriver;
import org.overlord.sramp.common.visitors.ArtifactVisitorAdapter;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;

public class WsdlLinker
extends ArtifactVisitorAdapter {
    private static ThreadLocal<LinkerContext> linkerContext = new ThreadLocal();

    public void link(LinkerContext context, BaseArtifactType derivedArtifact) {
        linkerContext.set(context);
        ArtifactVisitorHelper.visitArtifact(this, derivedArtifact);
    }

    @Override
    public void visit(Part artifact) {
        super.visit(artifact);
        ElementTarget element = artifact.getElement();
        XsdTypeTarget type = artifact.getType();
        BaseArtifactType artifactRef = null;
        if (element != null && element.getOtherAttributes().containsKey(WsdlDeriver.UNRESOLVED_REF)) {
            String encodedRef = (String)element.getOtherAttributes().remove(WsdlDeriver.UNRESOLVED_REF);
            QName ref = QName.valueOf(encodedRef);
            artifactRef = this.findArtifact(ArtifactTypeEnum.ElementDeclaration, ref);
            if (artifactRef != null) {
                element.setValue(artifactRef.getUuid());
            } else {
                artifact.setElement(null);
            }
        } else if (type != null && type.getOtherAttributes().containsKey(WsdlDeriver.UNRESOLVED_REF)) {
            String encodedRef = (String)type.getOtherAttributes().remove(WsdlDeriver.UNRESOLVED_REF);
            QName ref = QName.valueOf(encodedRef);
            artifactRef = this.findArtifact(ArtifactTypeEnum.ComplexTypeDeclaration, ref);
            if (artifactRef != null) {
                type.setValue(artifactRef.getUuid());
            } else {
                artifactRef = this.findArtifact(ArtifactTypeEnum.SimpleTypeDeclaration, ref);
                if (artifactRef != null) {
                    type.setValue(artifactRef.getUuid());
                } else {
                    artifact.setType(null);
                }
            }
        }
    }

    @Override
    public void visit(OperationInput artifact) {
        super.visit(artifact);
        MessageTarget message = artifact.getMessage();
        if (message != null && message.getOtherAttributes().containsKey(WsdlDeriver.UNRESOLVED_REF)) {
            String encodedRef = (String)message.getOtherAttributes().remove(WsdlDeriver.UNRESOLVED_REF);
            QName ref = QName.valueOf(encodedRef);
            BaseArtifactType artifactRef = this.findArtifact(ArtifactTypeEnum.Message, ref);
            if (artifactRef != null) {
                message.setValue(artifactRef.getUuid());
            } else {
                artifact.setMessage(null);
            }
        }
    }

    @Override
    public void visit(OperationOutput artifact) {
        super.visit(artifact);
        MessageTarget message = artifact.getMessage();
        if (message != null && message.getOtherAttributes().containsKey(WsdlDeriver.UNRESOLVED_REF)) {
            String encodedRef = (String)message.getOtherAttributes().remove(WsdlDeriver.UNRESOLVED_REF);
            QName ref = QName.valueOf(encodedRef);
            BaseArtifactType artifactRef = this.findArtifact(ArtifactTypeEnum.Message, ref);
            if (artifactRef != null) {
                message.setValue(artifactRef.getUuid());
            } else {
                artifact.setMessage(null);
            }
        }
    }

    @Override
    public void visit(Fault artifact) {
        super.visit(artifact);
        MessageTarget message = artifact.getMessage();
        if (message != null && message.getOtherAttributes().containsKey(WsdlDeriver.UNRESOLVED_REF)) {
            String encodedRef = (String)message.getOtherAttributes().remove(WsdlDeriver.UNRESOLVED_REF);
            QName ref = QName.valueOf(encodedRef);
            BaseArtifactType artifactRef = this.findArtifact(ArtifactTypeEnum.Message, ref);
            if (artifactRef != null) {
                message.setValue(artifactRef.getUuid());
            } else {
                artifact.setMessage(null);
            }
        }
    }

    @Override
    public void visit(Binding artifact) {
        super.visit(artifact);
        PortTypeTarget portType = artifact.getPortType();
        if (portType != null && portType.getOtherAttributes().containsKey(WsdlDeriver.UNRESOLVED_REF)) {
            String encodedRef = (String)portType.getOtherAttributes().remove(WsdlDeriver.UNRESOLVED_REF);
            QName ref = QName.valueOf(encodedRef);
            BaseArtifactType artifactRef = this.findArtifact(ArtifactTypeEnum.PortType, ref);
            if (artifactRef != null) {
                portType.setValue(artifactRef.getUuid());
            } else {
                artifact.setPortType(null);
            }
        }
    }

    @Override
    public void visit(Port artifact) {
        super.visit(artifact);
        BindingTarget binding = artifact.getBinding();
        if (binding != null && binding.getOtherAttributes().containsKey(WsdlDeriver.UNRESOLVED_REF)) {
            String encodedRef = (String)binding.getOtherAttributes().remove(WsdlDeriver.UNRESOLVED_REF);
            QName ref = QName.valueOf(encodedRef);
            BaseArtifactType artifactRef = this.findArtifact(ArtifactTypeEnum.Binding, ref);
            if (artifactRef != null) {
                binding.setValue(artifactRef.getUuid());
            } else {
                artifact.setBinding(null);
            }
        }
    }

    private BaseArtifactType findArtifact(ArtifactTypeEnum artifactType, QName reference) {
        LinkerContext lcontext = linkerContext.get();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("namespace", reference.getNamespaceURI());
        criteria.put("ncName", reference.getLocalPart());
        Collection<BaseArtifactType> artifacts = lcontext.findArtifacts(artifactType.getModel(), artifactType.getType(), criteria);
        if (artifacts != null && !artifacts.isEmpty()) {
            return artifacts.iterator().next();
        }
        return null;
    }
}

