/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.query.xpath;

import java.util.ArrayList;
import java.util.List;
import org.overlord.sramp.common.i18n.Messages;
import org.overlord.sramp.common.query.xpath.Token;
import org.overlord.sramp.common.query.xpath.TokenType;

public class TokenStream {
    private List<Token> tokens = new ArrayList<Token>();
    private Token[] stream;
    private int nextTokenPos;

    public void addToken(String value, TokenType type) {
        if (this.tokens == null) {
            throw new RuntimeException(Messages.i18n.format("TOKEN_STREAM_ALREADY_BUILT", new Object[0]));
        }
        this.tokens.add(new Token(type, value));
    }

    public TokenStream build() {
        if (this.tokens == null) {
            throw new RuntimeException(Messages.i18n.format("TOKEN_STREAM_ALREADY_BUILT_2", new Object[0]));
        }
        this.stream = this.tokens.toArray(new Token[this.tokens.size()]);
        this.tokens = null;
        this.nextTokenPos = 0;
        return this;
    }

    public boolean hasNext() {
        return this.nextTokenPos < this.stream.length;
    }

    public boolean canConsume(String tokenValue) {
        if (this.hasNext()) {
            Token nextToken = this.stream[this.nextTokenPos];
            if (nextToken.matches(tokenValue)) {
                ++this.nextTokenPos;
                return true;
            }
        }
        return false;
    }

    public boolean canConsume(String tokenValue1, String tokenValue2) {
        if (this.nextTokenPos + 1 < this.stream.length) {
            Token token1 = this.stream[this.nextTokenPos];
            Token token2 = this.stream[this.nextTokenPos + 1];
            if (token1.matches(tokenValue1) && token2.matches(tokenValue2)) {
                this.nextTokenPos += 2;
                return true;
            }
        }
        return false;
    }

    public boolean canConsumeAnyOf(String ... tokenValues) {
        Token nextToken;
        if (this.hasNext() && (nextToken = this.stream[this.nextTokenPos]).matches(tokenValues)) {
            ++this.nextTokenPos;
            return true;
        }
        return false;
    }

    public boolean matches(TokenType tokenType) {
        if (this.hasNext()) {
            Token nextToken = this.stream[this.nextTokenPos];
            return nextToken.matches(tokenType);
        }
        return false;
    }

    public boolean matchesAnyOf(TokenType ... tokenTypes) {
        if (this.hasNext()) {
            Token nextToken = this.stream[this.nextTokenPos];
            return nextToken.matches(tokenTypes);
        }
        return false;
    }

    public boolean matches(String tokenValue) {
        if (this.hasNext()) {
            Token nextToken = this.stream[this.nextTokenPos];
            return nextToken.matches(tokenValue);
        }
        return false;
    }

    public boolean matchesAnyOf(String ... tokenValues) {
        if (this.hasNext()) {
            Token nextToken = this.stream[this.nextTokenPos];
            return nextToken.matches(tokenValues);
        }
        return false;
    }

    public Token consume() {
        if (this.hasNext()) {
            return this.stream[this.nextTokenPos++];
        }
        return null;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        StringBuilder pbuilder = new StringBuilder();
        if (this.stream != null) {
            int count = 0;
            boolean first = true;
            for (Token token : this.stream) {
                if (!first) {
                    builder.append(" ");
                    pbuilder.append(" ");
                } else {
                    first = false;
                }
                builder.append(token.getValue());
                char filler = ' ';
                if (count == this.nextTokenPos) {
                    filler = '^';
                }
                for (int idx = 0; idx < token.getValue().length(); ++idx) {
                    pbuilder.append(filler);
                }
                ++count;
            }
        }
        return builder.toString() + "\n" + pbuilder.toString();
    }
}

