/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common.derived;

import java.io.InputStream;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.AttributeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ComplexTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DerivedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.DocumentArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ElementDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.SimpleTypeDeclaration;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.XsdDocument;
import org.overlord.sramp.common.derived.XsdDeriver;

public class XsdDeriverTest {
    private static final Set<String> EXPECTED_ELEMENT_NAMES = XsdDeriverTest.set("excludedOwners", "taskStakeholders", "recipients", "task", "leanTask", "potentialOwners", "businessAdministrators", "tasks", "logicalPeopleGroups", "genericHumanRole", "notifications", "priority", "taskInitiator", "notification", "import", "peopleAssignments", "humanInteractions");
    private static final Set<String> EXPECTED_ATTRIBUTE_NAMES = XsdDeriverTest.set(new String[0]);
    private static final Set<String> EXPECTED_SIMPLE_TYPE_NAMES = XsdDeriverTest.set("tPotentialDelegatees", "tPattern", "tRoutingPatternType", "tBoolean", "tCompositionType");
    private static final Set<String> EXPECTED_COMPLEX_TYPE_NAMES = XsdDeriverTest.set("tFrom", "tAggregate", "tMessageSchema", "tToPart", "tText", "tComposition", "tParameter", "tPeopleAssignments", "tExtension", "tRendering", "tPriority-expr", "tTask", "tReassignment", "tNotification", "tMessageField", "tDeadlines", "tCopy", "tDocumentation", "tDuration-expr", "tNotificationInterface", "tCompletion", "tExtensibleElements", "tHumanInteractions", "tTaskInterface", "tPotentialOwnerAssignment", "tNotifications", "tExtensions", "tPresentationParameter", "tPresentationElements", "tDeadline-expr", "tTasks", "tLogicalPeopleGroups", "tDescription", "tQuery", "tLocalNotification", "tLogicalPeopleGroup", "tSubtask", "tExtensibleMixedContentElements", "tSequence", "tExpression", "tToParts", "tResult", "tRenderings", "tGenericHumanRoleAssignmentBase", "tParallel", "tDeadline", "tPresentationParameters", "tArgument", "tMessageChoice", "tDelegation", "tLocalTask", "tBoolean-expr", "tEscalation", "tLeanTask", "tImport", "tDefaultCompletion", "tMessageDisplay", "tCompletionBehavior", "tGenericHumanRoleAssignment", "tLiteral", "tTaskBase");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDerive() throws Exception {
        DatatypeFactory dtFactory = DatatypeFactory.newInstance();
        XsdDeriver deriver = new XsdDeriver();
        XsdDocument testSrcArtifact = new XsdDocument();
        testSrcArtifact.setArtifactType(BaseArtifactEnum.XSD_DOCUMENT);
        testSrcArtifact.setUuid(UUID.randomUUID().toString());
        testSrcArtifact.setName("ws-humantask.xsd");
        testSrcArtifact.setVersion("1.0");
        testSrcArtifact.setContentEncoding("UTF-8");
        testSrcArtifact.setContentType("application/xml");
        testSrcArtifact.setContentSize(Long.valueOf(31723L));
        testSrcArtifact.setCreatedBy("anonymous");
        XMLGregorianCalendar xmlGC = dtFactory.newXMLGregorianCalendar(new GregorianCalendar());
        testSrcArtifact.setCreatedTimestamp(xmlGC);
        testSrcArtifact.setDescription("Hello world.");
        testSrcArtifact.setLastModifiedBy("anonymous");
        testSrcArtifact.setLastModifiedTimestamp(xmlGC);
        InputStream testSrcContent = null;
        try {
            testSrcContent = this.getClass().getResourceAsStream("/sample-files/xsd/ws-humantask.xsd");
            Collection derivedArtifacts = deriver.derive((BaseArtifactType)testSrcArtifact, testSrcContent);
            Assert.assertNotNull((Object)derivedArtifacts);
            Assert.assertEquals((long)83L, (long)derivedArtifacts.size());
            int numElements = 0;
            int numAttributes = 0;
            int numSimpleTypes = 0;
            int numComplexTypes = 0;
            HashSet<String> elementNames = new HashSet<String>();
            HashSet<String> attributeNames = new HashSet<String>();
            HashSet<String> simpleTypeNames = new HashSet<String>();
            HashSet<String> complexTypeNames = new HashSet<String>();
            for (BaseArtifactType derivedArtifact : derivedArtifacts) {
                DerivedArtifactType dat = (DerivedArtifactType)derivedArtifact;
                Assert.assertEquals((Object)testSrcArtifact.getUuid(), (Object)dat.getRelatedDocument().getValue());
                Assert.assertEquals((Object)DocumentArtifactEnum.XSD_DOCUMENT, (Object)dat.getRelatedDocument().getArtifactType());
                if (dat instanceof ElementDeclaration) {
                    ++numElements;
                    elementNames.add(((ElementDeclaration)dat).getNCName());
                    continue;
                }
                if (dat instanceof AttributeDeclaration) {
                    ++numAttributes;
                    attributeNames.add(((AttributeDeclaration)dat).getNCName());
                    continue;
                }
                if (dat instanceof SimpleTypeDeclaration) {
                    ++numSimpleTypes;
                    simpleTypeNames.add(((SimpleTypeDeclaration)dat).getNCName());
                    continue;
                }
                if (!(dat instanceof ComplexTypeDeclaration)) continue;
                ++numComplexTypes;
                complexTypeNames.add(((ComplexTypeDeclaration)dat).getNCName());
            }
            Assert.assertEquals((long)17L, (long)numElements);
            Assert.assertEquals((long)0L, (long)numAttributes);
            Assert.assertEquals((long)5L, (long)numSimpleTypes);
            Assert.assertEquals((long)61L, (long)numComplexTypes);
            Assert.assertEquals((long)83L, (long)(numElements + numAttributes + numSimpleTypes + numComplexTypes));
            Assert.assertEquals(EXPECTED_ELEMENT_NAMES, elementNames);
            Assert.assertEquals(EXPECTED_ATTRIBUTE_NAMES, attributeNames);
            Assert.assertEquals(EXPECTED_SIMPLE_TYPE_NAMES, simpleTypeNames);
            Assert.assertEquals(EXPECTED_COMPLEX_TYPE_NAMES, complexTypeNames);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(testSrcContent);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)testSrcContent);
    }

    private static Set<String> set(String ... values) {
        HashSet<String> rval = new HashSet<String>();
        for (String val : values) {
            rval.add(val);
        }
        return rval;
    }
}

