/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.common;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.overlord.commons.config.ConfigurationFactory;
import org.overlord.commons.config.JBossServer;
import org.overlord.sramp.common.Version;

public class Sramp {
    private static Configuration configuration = null;

    public String getBaseUrl(String requestUrl) {
        String baseUrl = null;
        if (requestUrl != null) {
            int index = requestUrl.indexOf("/s-ramp/");
            if (index < 0) {
                index = requestUrl.indexOf("/s-ramp");
            }
            if (index > 0) {
                baseUrl = requestUrl.substring(0, index);
            }
        }
        if (baseUrl == null) {
            baseUrl = JBossServer.getBaseUrl() + "/s-ramp-server";
        }
        return configuration.getString("sramp.config.baseurl", baseUrl);
    }

    public boolean isAuditingEnabled() {
        return configuration.getBoolean("sramp.config.auditing.enabled", true);
    }

    public boolean isDerivedArtifactAuditingEnabled() {
        return configuration.getBoolean("sramp.config.auditing.enabled-derived", true);
    }

    public String getConfigProperty(String propertyName, String propertyDefault) {
        return configuration.getString(propertyName, propertyDefault);
    }

    public String getJCRRepositoryName() {
        return this.getConfigProperty("sramp.config.jcr.repository.name", "sramp");
    }

    public String getMavenReadOnlyUsername() {
        return this.getConfigProperty("sramp.config.maven.readonly-username", "mavenuser");
    }

    private boolean isSnapshot() {
        String version = this.getVersion();
        return StringUtils.isNotBlank((String)version) && version.contains("SNAPSHOT");
    }

    private String getVersion() {
        return Version.get().getVersionString();
    }

    public boolean containsKey(String key) {
        return configuration.containsKey(key);
    }

    public boolean isSnapshotAllowed() {
        if ("true".equalsIgnoreCase(System.getProperty("sramp.config.maven.allow-snapshots"))) {
            return true;
        }
        if (this.containsKey("sramp.config.maven.allow-snapshots")) {
            String value = this.getConfigProperty("sramp.config.maven.allow-snapshots", "false");
            return StringUtils.isNotBlank((String)value) && value.equals("true");
        }
        return this.isSnapshot();
    }

    static {
        String configFile = System.getProperty("sramp.config.file.name");
        String refreshDelayStr = System.getProperty("sramp.config.file.refresh");
        Long refreshDelay = 5000L;
        if (refreshDelayStr != null) {
            refreshDelay = new Long(refreshDelayStr);
        }
        configuration = ConfigurationFactory.createConfig((String)configFile, (String)"sramp.properties", (Long)refreshDelay, null, null);
    }
}

