/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.configuration.reloading.FileChangedReloadingStrategy;
import org.apache.commons.configuration.reloading.ReloadingStrategy;
import org.overlord.sramp.governance.ConfigException;
import org.overlord.sramp.governance.NotificationDestinations;
import org.overlord.sramp.governance.Query;
import org.overlord.sramp.governance.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Governance {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    public static String QUERY_ERROR = "governance.queries should be of the format <query>|<processId>|<param::param>\nCheck\n";
    public static String TARGET_ERROR = "governance.targets should be of the format <targetName>|<directory>\nCheck\n";
    public static String NOTIFICATION_ERROR = "governance..<email|..> should be of the format <groupName>|<fromAddress>|<destination1>,<destination2>\nCheck\n";
    private static Configuration configuration = null;

    public Governance() {
        if (configuration == null) {
            this.read();
        }
    }

    protected synchronized void read() {
        try {
            CompositeConfiguration config = new CompositeConfiguration();
            config.addConfiguration((Configuration)new SystemConfiguration());
            String configFile = config.getString("governance.file.name", "governance.properties");
            Long refreshDelay = config.getLong("governance.file.refresh", 5000L);
            URL url = Governance.class.getClassLoader().getResource(configFile);
            if (url == null) {
                this.log.warn("Cannot find " + configFile);
            } else {
                PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(url);
                FileChangedReloadingStrategy fileChangedReloadingStrategy = new FileChangedReloadingStrategy();
                fileChangedReloadingStrategy.setRefreshDelay(refreshDelay.longValue());
                propertiesConfiguration.setReloadingStrategy((ReloadingStrategy)fileChangedReloadingStrategy);
                config.addConfiguration((Configuration)propertiesConfiguration);
            }
            configuration = config;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String validate() throws ConfigException {
        StringBuffer configuration = new StringBuffer();
        try {
            configuration.append("Governance configuration:").append("\n");
            configuration.append("governance.jbpm.url: " + this.getJbpmUrl()).append("\n");
            configuration.append("governance.jbpm.user: " + this.getJbpmUser()).append("\n");
            configuration.append("governance.jbpm.password: " + this.getJbpmPassword().replaceAll(".", "*")).append("\n");
            configuration.append("sramp.repo.url: " + this.getSrampUrl()).append("\n");
            int i = 1;
            for (Query query : this.getQueries()) {
                configuration.append("Query ").append(i++).append("\n");
                configuration.append(query.toString()).append("\n\n");
            }
            i = 1;
            for (String name : this.getTargets().keySet()) {
                configuration.append("Target ").append(i++).append("\n");
                configuration.append(this.getTargets().get(name).toString()).append("\n\n");
            }
            this.log.debug(configuration.toString());
            return configuration.toString();
        }
        catch (MalformedURLException e) {
            throw new ConfigException(e);
        }
    }

    public String getJbpmUser() {
        return configuration.getString("governance.jbpm.user", "admin");
    }

    public String getJbpmPassword() {
        return configuration.getString("governance.jbpm.password", "admin");
    }

    public URL getJbpmUrl() throws MalformedURLException {
        return new URL(configuration.getString("governance.jbpm.url", "http://localhost:8080/gwt-console-server"));
    }

    public URL getSrampUrl() throws MalformedURLException {
        return new URL(configuration.getString("sramp.repo.url", "http://localhost:8080/s-ramp-server"));
    }

    public Map<String, Target> getTargets() throws ConfigException {
        HashMap<String, Target> targets = new HashMap<String, Target>();
        String[] targetStrings = configuration.getStringArray("governance.targets");
        StringBuffer errors = new StringBuffer(TARGET_ERROR);
        boolean hasErrors = false;
        for (String targetString : targetStrings) {
            String[] info = targetString.split("\\|");
            if (info.length != 2) {
                hasErrors = true;
                errors.append(targetString).append("\n");
            }
            if (hasErrors) continue;
            Target target = new Target(info[0], info[1]);
            targets.put(target.getName(), target);
        }
        if (hasErrors) {
            throw new ConfigException(errors.toString());
        }
        return targets;
    }

    public Set<Query> getQueries() throws ConfigException {
        HashSet<Query> queries = new HashSet<Query>();
        String[] queryStrings = configuration.getStringArray("governance.queries");
        StringBuffer errors = new StringBuffer(QUERY_ERROR);
        boolean hasErrors = false;
        for (String queryString : queryStrings) {
            String[] info = queryString.split("\\|");
            if (info.length != 3) {
                hasErrors = true;
                errors.append(queryString).append("\n");
            }
            if (hasErrors) continue;
            Query query = new Query(info[0], info[1], info[2]);
            queries.add(query);
        }
        if (hasErrors) {
            throw new ConfigException(errors.toString());
        }
        return queries;
    }

    public Map<String, NotificationDestinations> getNotificationDestinations(String channel) throws ConfigException {
        HashMap<String, NotificationDestinations> destinationMap = new HashMap<String, NotificationDestinations>();
        String[] destinationStrings = configuration.getStringArray("governance." + channel);
        StringBuffer errors = new StringBuffer(NOTIFICATION_ERROR);
        boolean hasErrors = false;
        for (String destinationString : destinationStrings) {
            String[] info = destinationString.split("\\|");
            if (info.length != 3) {
                hasErrors = true;
                errors.append(destinationString).append("\n");
            }
            if (hasErrors) continue;
            NotificationDestinations destination = new NotificationDestinations(info[0], info[1], info[2]);
            destinationMap.put(destination.getName(), destination);
        }
        if (hasErrors) {
            throw new ConfigException(errors.toString());
        }
        return destinationMap;
    }

    public long getQueryInterval() {
        return configuration.getLong("governance.query.interval", 300000L);
    }

    public long getAcceptableLagtime() {
        return configuration.getLong("governance.acceptable.lagtime", 1000L);
    }
}

