/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.configuration.ConfigurationException;
import org.overlord.sramp.client.SrampClientException;
import org.overlord.sramp.governance.ConfigException;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.QueryExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SRAMPMonitor
extends TimerTask {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Timer timer = null;
    Governance governance = new Governance();
    private long interval = this.governance.getQueryInterval();
    private long acceptableLagTime = this.governance.getAcceptableLagtime();

    public SRAMPMonitor() throws ConfigurationException {
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)this, 0L, this.interval);
    }

    @Override
    public boolean cancel() {
        this.timer.cancel();
        return super.cancel();
    }

    @Override
    public synchronized void run() {
        try {
            if (this.firedOnTime(this.scheduledExecutionTime()) && this.isAppserverReady()) {
                long startTime = System.currentTimeMillis();
                QueryExecutor queryExecutor = new QueryExecutor();
                queryExecutor.execute();
                long endTime = System.currentTimeMillis();
                if (endTime - startTime > this.interval) {
                    this.log.debug("Notification background task duration exceeds the JUDDI_NOTIFICATION_INTERVAL of " + this.interval + ". Notification background task took " + (endTime - startTime) + " milliseconds.");
                } else {
                    this.log.debug("Notification background task took " + (endTime - startTime) + " milliseconds.");
                }
            } else {
                this.log.debug("Skipping current notification cycle because lagtime is too great.");
            }
        }
        catch (ConfigException confEx) {
            this.log.error(confEx.getMessage());
        }
        catch (SrampClientException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean firedOnTime(long scheduleExecutionTime) {
        long lagTime = System.currentTimeMillis() - scheduleExecutionTime;
        if (lagTime <= this.acceptableLagTime || this.acceptableLagTime < 0L) {
            return true;
        }
        this.log.debug("NotificationTimer is lagging " + lagTime + " milli seconds behind. A lag time " + "which exceeds an acceptable lagtime of " + this.acceptableLagTime + "ms indicates " + "that the registry server is under load or was in sleep mode. We are therefore skipping this notification " + "cycle.");
        return false;
    }

    private boolean isAppserverReady() throws MalformedURLException {
        boolean isReady = true;
        String serviceDocumentUrl = this.governance.getSrampUrl().toExternalForm() + "/s-ramp/serviceDocument";
        isReady = this.urlExists(serviceDocumentUrl);
        if (isReady) {
            String bpmUrl = this.governance.getJbpmUrl().toExternalForm();
            isReady = this.urlExists(bpmUrl);
            if (!isReady) {
                this.log.info("Cannot yet connect to the BPM API at: " + this.governance.getJbpmUrl().toExternalForm());
            }
        } else if (!isReady) {
            this.log.info("Cannot yet connect to the S-RAMP repo at: " + this.governance.getSrampUrl().toExternalForm());
        }
        return isReady;
    }

    public boolean urlExists(String checkUrl) {
        try {
            URL checkURL = new URL(checkUrl);
            HttpURLConnection checkConnection = (HttpURLConnection)checkURL.openConnection();
            checkConnection.setRequestMethod("GET");
            checkConnection.setConnectTimeout(10000);
            checkConnection.setReadTimeout(10000);
            checkConnection.connect();
            return checkConnection.getResponseCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }
}

