/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.Target;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/deploy")
public class DeploymentResource {
    private static Logger logger = LoggerFactory.getLogger(DeploymentResource.class);
    private Governance governance = new Governance();

    @POST
    @Path(value="copy/{environment}/{uuid}")
    @Produces(value={"application/xml"})
    public Response copy(@Context HttpServletRequest request, @PathParam(value="environment") String environment, @PathParam(value="uuid") String uuid) throws Exception {
        Response response;
        InputStream is = null;
        FileOutputStream os = null;
        try {
            File file;
            SrampAtomApiClient client = new SrampAtomApiClient(this.governance.getSrampUrl().toExternalForm());
            String query = String.format("/s-ramp[@uuid='%s']", uuid);
            QueryResultSet queryResultSet = client.query(query);
            if (queryResultSet.size() == 0L) {
                Response response2 = Response.serverError().status(0).build();
                return response2;
            }
            ArtifactSummary artifactSummary = (ArtifactSummary)queryResultSet.iterator().next();
            is = client.getArtifactContent(artifactSummary.getType(), uuid);
            Target target = this.governance.getTargets().get(environment);
            if (target == null) {
                logger.error("No target could be found for environment '" + environment + "'");
                throw new SrampAtomException("No target could be found for environment '" + environment + "'");
            }
            File deployDir = new File(target.getDeployDir());
            if (!deployDir.exists()) {
                logger.info("creating " + deployDir);
                deployDir.mkdirs();
            }
            if ((file = new File(deployDir + "/" + artifactSummary.getName())).exists()) {
                file.delete();
            }
            file.createNewFile();
            os = new FileOutputStream(file);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            InputStream reply = IOUtils.toInputStream((String)"success");
            response = Response.ok((Object)reply, (String)"application/octet-stream").build();
            IOUtils.closeQuietly((OutputStream)os);
        }
        catch (Exception e) {
            logger.error("Error deploying artifact. " + e.getMessage(), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly(os);
            IOUtils.closeQuietly(is);
        }
        IOUtils.closeQuietly((InputStream)is);
        return response;
    }
}

