/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance.services;

import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import javax.annotation.Resource;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.client.query.ArtifactSummary;
import org.overlord.sramp.client.query.QueryResultSet;
import org.overlord.sramp.governance.Governance;
import org.overlord.sramp.governance.NotificationDestinations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/notify")
public class NotificationResource {
    @Resource(mappedName="java:jboss/mail/Default")
    private Session mailSession;
    private static Logger logger = LoggerFactory.getLogger(NotificationResource.class);
    private Governance governance = new Governance();

    @POST
    @Path(value="email/{group}/{template}/{environment}/{uuid}")
    @Produces(value={"application/xml"})
    public Response emailNotification(@Context HttpServletRequest request, @PathParam(value="group") String group, @PathParam(value="template") String template, @PathParam(value="environment") String environment, @PathParam(value="uuid") String uuid) throws Exception {
        try {
            SrampAtomApiClient client = new SrampAtomApiClient(this.governance.getSrampUrl().toExternalForm());
            String query = String.format("/s-ramp[@uuid='%s']", uuid);
            QueryResultSet queryResultSet = client.query(query);
            if (queryResultSet.size() == 0L) {
                return Response.serverError().status(0).build();
            }
            ArtifactSummary artifactSummary = (ArtifactSummary)queryResultSet.iterator().next();
            NotificationDestinations destinations = this.governance.getNotificationDestinations("email").get(group);
            if (destinations == null) {
                logger.error("No emailAddresses could be found for group '" + group + "'");
                throw new SrampAtomException("No email addresses could be found for group '" + group + "'");
            }
            try {
                MimeMessage m = new MimeMessage(this.mailSession);
                InternetAddress from = new InternetAddress(destinations.getFromAddress());
                InternetAddress[] to = new InternetAddress[destinations.getToAddresses().length];
                for (int i = 0; i < destinations.getToAddresses().length; ++i) {
                    to[i] = new InternetAddress(destinations.getToAddresses()[i]);
                }
                m.setFrom((Address)from);
                m.setRecipients(Message.RecipientType.TO, (Address[])to);
                String subject = "/governance-email-templates/" + template + ".subject.tmpl";
                URL subjectUrl = Governance.class.getClassLoader().getResource(subject);
                if (subjectUrl != null) {
                    subject = IOUtils.toString((URL)subjectUrl);
                }
                subject = subject.replaceAll("\\$\\{uuid}", uuid);
                subject = subject.replaceAll("\\$\\{name}", artifactSummary.getName());
                subject = subject.replaceAll("\\$\\{environment}", environment);
                m.setSubject(subject);
                m.setSentDate(new Date());
                String content = "/governance-email-templates/" + template + ".body.tmpl";
                URL contentUrl = Governance.class.getClassLoader().getResource(content);
                if (contentUrl != null) {
                    content = IOUtils.toString((URL)contentUrl);
                }
                content = content.replaceAll("\\$\\{uuid}", uuid);
                content = content.replaceAll("\\$\\{name}", artifactSummary.getName());
                content = content.replaceAll("\\$\\{environment}", environment);
                m.setContent((Object)content, "text/plain");
                Transport.send((Message)m);
            }
            catch (MessagingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            InputStream reply = IOUtils.toInputStream((String)"success");
            return Response.ok((Object)reply, (String)"application/octet-stream").build();
        }
        catch (Exception e) {
            logger.error("Error sending a notification email. " + e.getMessage(), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
    }
}

