/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.governance;

import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;
import org.overlord.sramp.governance.ConfigException;
import org.overlord.sramp.governance.Governance;

public class ConfigurationTest {
    @Test
    public void testConfigure() throws ConfigException {
        Governance governance = new Governance();
        Map targets = governance.getTargets();
        Assert.assertTrue((targets.size() > 0 ? 1 : 0) != 0);
        Set queries = governance.getQueries();
        Assert.assertTrue((queries.size() > 0 ? 1 : 0) != 0);
        System.out.println(governance.validate());
    }

    @Test
    public void testBad1UrlConfiguration() throws ConfigException {
        System.setProperty("governance.file.name", "bad1-governance.properties");
        Governance governance = new Governance();
        governance.read();
        try {
            System.out.println(governance.validate());
            Assert.fail((String)"Expecting exception");
        }
        catch (ConfigException e) {
            Assert.assertEquals((String)"java.net.MalformedURLException: no protocol: http//localhost:8080/s-ramp-atom", (String)e.getMessage());
        }
    }

    @Test
    public void testBad2QueryConfiguration() throws ConfigException {
        System.setProperty("governance.file.name", "bad2-governance.properties");
        Governance governance = new Governance();
        governance.read();
        try {
            governance.validate();
            Assert.fail((String)"Expecting exception");
        }
        catch (ConfigException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith(Governance.QUERY_ERROR));
        }
    }

    @Test
    public void testBad3TargetConfiguration() throws ConfigException {
        System.setProperty("governance.file.name", "bad3-governance.properties");
        Governance governance = new Governance();
        governance.read();
        try {
            governance.validate();
            Assert.fail((String)"Expecting exception");
        }
        catch (ConfigException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith(Governance.TARGET_ERROR));
        }
    }
}

