/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.java.expand;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchive;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchiveException;
import org.overlord.sramp.atom.archive.expand.registry.TypeHintInfo;
import org.overlord.sramp.atom.archive.expand.registry.ZipToSrampArchiveProvider;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.integration.java.expand.JarToSrampArchive;

public class JarToSrampArchiveProvider
implements ZipToSrampArchiveProvider {
    private static final Map<String, String> hintsMap;
    private static final Set<String> acceptedTypes;

    public boolean accept(ArtifactType artifactType) {
        if (artifactType.isExtendedType()) {
            String extendedType = artifactType.getExtendedType();
            return acceptedTypes.contains(extendedType);
        }
        return false;
    }

    public ZipToSrampArchive createExtractor(ArtifactType artifactType, File zipFile) throws ZipToSrampArchiveException {
        return new JarToSrampArchive(zipFile);
    }

    public ZipToSrampArchive createExtractor(ArtifactType artifactType, InputStream zipStream) throws ZipToSrampArchiveException {
        return new JarToSrampArchive(zipStream);
    }

    public TypeHintInfo getArchiveTypeHints() {
        return new TypeHintInfo(Integer.valueOf(100), hintsMap);
    }

    static {
        acceptedTypes = new HashSet<String>();
        acceptedTypes.add("JavaArchive");
        acceptedTypes.add("JavaWebApplication");
        acceptedTypes.add("JavaEnterpriseApplication");
        TreeMap<String, String> aMap = new TreeMap<String, String>();
        aMap.put("META-INF/application.xml", "JavaEnterpriseApplication");
        aMap.put("WEB-INF/web.xml", "JavaWebApplication");
        aMap.put("META-INF/MANIFEST.MF", "JavaArchive");
        hintsMap = Collections.unmodifiableMap(aMap);
    }
}

