/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.kie.jar;

import java.io.InputStream;
import java.util.Collection;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.atom.archive.SrampArchiveException;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchive;
import org.overlord.sramp.integration.kie.expand.KieJarToSrampArchive;

public class KieJarToSrampArchiveTest {
    private static final String EXPECTED_ENTRIES = "META-INF/kmodule.xml\nSRAMPPackage/overlord.demo.CheckDeployment-taskform.xml\nSRAMPPackage/overlord.demo.ProjectLifeCycle.bpmn2\nSRAMPPackage/overlord.demo.SimpleReleaseProcess.bpmn\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testKieIntegration() throws Exception {
        InputStream stream = this.getClass().getResourceAsStream("kie.jar");
        SrampArchive archive = null;
        KieJarToSrampArchive kie2archive = null;
        try {
            kie2archive = new KieJarToSrampArchive(stream);
            archive = kie2archive.createSrampArchive();
            Assert.assertNotNull((Object)archive);
            this.doAllAssertions(archive);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((InputStream)stream);
            SrampArchive.closeQuietly(archive);
            ZipToSrampArchive.closeQuietly((ZipToSrampArchive)kie2archive);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)stream);
        SrampArchive.closeQuietly((SrampArchive)archive);
        ZipToSrampArchive.closeQuietly((ZipToSrampArchive)kie2archive);
    }

    private void doAllAssertions(SrampArchive archive) throws SrampArchiveException {
        Collection entries = archive.getEntries();
        TreeSet<String> entryNames = new TreeSet<String>();
        for (SrampArchiveEntry srampArchiveEntry : entries) {
            entryNames.add(srampArchiveEntry.getPath());
        }
        StringBuilder buff = new StringBuilder();
        for (String entryName : entryNames) {
            buff.append(entryName).append("\n");
        }
        Assert.assertEquals((Object)EXPECTED_ENTRIES, (Object)buff.toString());
        SrampArchiveEntry entry = archive.getEntry("META-INF/kmodule.xml");
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((Object)"kmodule.xml", (Object)entry.getMetaData().getName());
        Assert.assertEquals((Object)BaseArtifactEnum.EXTENDED_DOCUMENT, (Object)entry.getMetaData().getArtifactType());
        ExtendedDocument kieXmlDoc = (ExtendedDocument)entry.getMetaData();
        Assert.assertEquals((Object)"KieXmlDocument", (Object)kieXmlDoc.getExtendedType());
    }
}

