/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.switchyard.deriver;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Document;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.derived.LinkerContext;
import org.overlord.sramp.integration.switchyard.deriver.SwitchYardXmlDeriver;
import org.overlord.sramp.integration.switchyard.model.SwitchYardModel;

public class SwitchYardXmlDeriverTest {
    @Test
    public void testSwitchyardDeriver() throws IOException {
        SwitchYardXmlDeriver deriver = new SwitchYardXmlDeriver();
        ExtendedDocument artifact = new ExtendedDocument();
        artifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        artifact.setName("switchyard.xml");
        artifact.setExtendedType("SwitchYardXmlDocument");
        InputStream is = this.getClass().getResourceAsStream("switchyard.xml");
        Collection derivedArtifacts = deriver.derive((BaseArtifactType)artifact, is);
        Assert.assertNotNull((Object)derivedArtifacts);
        Assert.assertEquals((long)9L, (long)derivedArtifacts.size());
        Assert.assertEquals((Object)"orders", (Object)artifact.getName());
        Assert.assertEquals((Object)"urn:switchyard-quickstart:bean-service:0.1.0", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"targetNamespace"));
        BaseArtifactType orderService = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardServiceType, "OrderService");
        Assert.assertNotNull((Object)orderService);
        Assert.assertEquals((Object)"OrderService", (Object)orderService.getName());
        BaseArtifactType inventoryServiceComponent = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardComponentType, "InventoryService");
        Assert.assertNotNull((Object)inventoryServiceComponent);
        Assert.assertEquals((Object)"managedTransaction.Global", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)inventoryServiceComponent, (String)"requires"));
        Relationship relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)inventoryServiceComponent, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertTrue((boolean)relationship.getRelationshipTarget().isEmpty());
        Assert.assertTrue((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)inventoryServiceComponent, (String)"references");
        Assert.assertNull((Object)relationship);
        BaseArtifactType orderServiceComponent = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardComponentType, "OrderService");
        Assert.assertNotNull((Object)orderServiceComponent);
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)orderServiceComponent, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertTrue((boolean)relationship.getRelationshipTarget().isEmpty());
        Assert.assertTrue((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)orderServiceComponent, (String)"references");
        Assert.assertNotNull((Object)relationship);
        Assert.assertTrue((boolean)relationship.getRelationshipTarget().isEmpty());
        Assert.assertTrue((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)orderService, (String)"promotes");
        Assert.assertNotNull((Object)relationship);
        Assert.assertNotNull((Object)relationship.getRelationshipTarget());
        Assert.assertFalse((boolean)relationship.getRelationshipTarget().isEmpty());
        Assert.assertEquals((Object)orderServiceComponent.getUuid(), (Object)((Target)relationship.getRelationshipTarget().iterator().next()).getValue());
        BaseArtifactType camelServiceComponent = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardComponentType, "CamelService");
        Assert.assertNotNull((Object)camelServiceComponent);
        Assert.assertEquals((Object)"noManagedTransaction", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)camelServiceComponent, (String)"requires"));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)camelServiceComponent, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertTrue((boolean)relationship.getRelationshipTarget().isEmpty());
        Assert.assertTrue((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)camelServiceComponent, (String)"references");
        Assert.assertNull((Object)relationship);
        BaseArtifactType transformJava = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardTransformerType, "OrderAck->submitOrderResponse");
        Assert.assertNotNull((Object)transformJava);
        Assert.assertEquals((Object)"java", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)transformJava, (String)"transformer-type"));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertTrue((boolean)relationship.getRelationshipTarget().isEmpty());
        Assert.assertTrue((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsFrom");
        Assert.assertNotNull((Object)relationship);
        Assert.assertTrue((boolean)relationship.getRelationshipTarget().isEmpty());
        Assert.assertTrue((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsTo");
        Assert.assertNotNull((Object)relationship);
        Assert.assertTrue((boolean)relationship.getRelationshipTarget().isEmpty());
        Assert.assertTrue((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        BaseArtifactType transformXslt = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardTransformerType, "CDM->S1");
        Assert.assertNotNull((Object)transformXslt);
        Assert.assertEquals((Object)"xslt", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)transformXslt, (String)"transformer-type"));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformXslt, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertTrue((boolean)relationship.getRelationshipTarget().isEmpty());
        Assert.assertTrue((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsFrom");
        Assert.assertNotNull((Object)relationship);
        Assert.assertTrue((boolean)relationship.getRelationshipTarget().isEmpty());
        Assert.assertTrue((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsTo");
        Assert.assertNotNull((Object)relationship);
        Assert.assertTrue((boolean)relationship.getRelationshipTarget().isEmpty());
        Assert.assertTrue((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        BaseArtifactType validateJava = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardValidatorType, "java:org.switchyard.quickstarts.bean.service.Order");
        Assert.assertNotNull((Object)validateJava);
        Assert.assertEquals((Object)"java", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)validateJava, (String)"validator-type"));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)validateJava, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertTrue((boolean)relationship.getRelationshipTarget().isEmpty());
        Assert.assertTrue((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)validateJava, (String)"validates");
        Assert.assertNotNull((Object)relationship);
        Assert.assertTrue((boolean)relationship.getRelationshipTarget().isEmpty());
        Assert.assertTrue((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        LinkerContext context = new LinkerContext(){

            public Collection<BaseArtifactType> findArtifacts(String model, String type, Map<String, String> criteria) {
                Document doc = new Document();
                doc.setArtifactType(BaseArtifactEnum.DOCUMENT);
                doc.setName("Mock Artifact");
                doc.setUuid(UUID.randomUUID().toString());
                return Collections.singletonList(doc);
            }
        };
        deriver.link(context, (BaseArtifactType)artifact, derivedArtifacts);
        inventoryServiceComponent = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardComponentType, "InventoryService");
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)inventoryServiceComponent, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        Assert.assertFalse((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)inventoryServiceComponent, (String)"references");
        Assert.assertNull((Object)relationship);
        orderServiceComponent = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardComponentType, "OrderService");
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)orderServiceComponent, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        Assert.assertFalse((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)orderServiceComponent, (String)"references");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        Assert.assertFalse((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        camelServiceComponent = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardComponentType, "CamelService");
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)camelServiceComponent, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertFalse((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        transformJava = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardTransformerType, "OrderAck->submitOrderResponse");
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        Assert.assertFalse((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsFrom");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        Assert.assertFalse((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsTo");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        Assert.assertFalse((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        transformXslt = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardTransformerType, "CDM->S1");
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformXslt, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertFalse((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsFrom");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        Assert.assertFalse((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsTo");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        Assert.assertFalse((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        validateJava = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardValidatorType, "java:org.switchyard.quickstarts.bean.service.Order");
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)validateJava, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertFalse((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)validateJava, (String)"validates");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        Assert.assertFalse((boolean)relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF));
    }

    private BaseArtifactType getDerivedArtifact(Collection<BaseArtifactType> derivedArtifacts, ArtifactType artifactType, String name) {
        for (BaseArtifactType artifact : derivedArtifacts) {
            ArtifactType at = ArtifactType.valueOf((BaseArtifactType)artifact);
            if (!at.equals((Object)artifactType) || !artifact.getName().equals(name)) continue;
            return artifact;
        }
        return null;
    }
}

