/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.switchyard.deriver;

import java.util.Collection;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.overlord.sramp.common.ArtifactTypeEnum;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.derived.LinkerContext;
import org.overlord.sramp.integration.switchyard.deriver.SwitchYardXmlDeriver;
import org.overlord.sramp.integration.switchyard.model.SwitchYardArtifactVisitor;
import org.overlord.sramp.integration.switchyard.model.SwitchYardArtifactVisitorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchYardLinker
implements SwitchYardArtifactVisitor {
    private static Logger log = LoggerFactory.getLogger(SwitchYardLinker.class);
    private static ThreadLocal<LinkerContext> linkerContext = new ThreadLocal();

    @Override
    public void visitService(ExtendedArtifactType artifact) {
    }

    @Override
    public void visitComponent(ExtendedArtifactType artifact) {
        Target target;
        String refClassName;
        BaseArtifactType artifactRef;
        String ref;
        Relationship relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)artifact, (String)"implementedBy");
        if (relationship != null && relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF) && (ref = (String)relationship.getOtherAttributes().remove(SwitchYardXmlDeriver.UNRESOLVED_REF)).startsWith("class:") && (artifactRef = this.findJavaClassArtifact(refClassName = ref.substring(6))) != null) {
            target = new Target();
            target.setValue(artifactRef.getUuid());
            relationship.getRelationshipTarget().add(target);
        }
        if ((relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)artifact, (String)"references")) != null && relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF)) {
            String refWsdl;
            ref = (String)relationship.getOtherAttributes().remove(SwitchYardXmlDeriver.UNRESOLVED_REF);
            if (ref.startsWith("java:")) {
                String refInterfaceName = ref.substring(5);
                artifactRef = this.findJavaInterfaceArtifact(refInterfaceName);
                if (artifactRef != null) {
                    target = new Target();
                    target.setValue(artifactRef.getUuid());
                    relationship.getRelationshipTarget().add(target);
                }
            } else if (ref.startsWith("wsdl:") && (artifactRef = this.findWsdlArtifact(refWsdl = ref.substring(5))) != null) {
                target = new Target();
                target.setValue(artifactRef.getUuid());
                relationship.getRelationshipTarget().add(target);
            }
        }
    }

    @Override
    public void visitTransformer(ExtendedArtifactType artifact) {
        QName refQName;
        Target target;
        BaseArtifactType artifactRef;
        String refClassName;
        String ref;
        Relationship relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)artifact, (String)"implementedBy");
        if (relationship != null && relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF)) {
            String camelPath;
            ref = (String)relationship.getOtherAttributes().remove(SwitchYardXmlDeriver.UNRESOLVED_REF);
            if (ref.startsWith("class:")) {
                refClassName = ref.substring(6);
                artifactRef = this.findJavaClassArtifact(refClassName);
                if (artifactRef != null) {
                    target = new Target();
                    target.setValue(artifactRef.getUuid());
                    relationship.getRelationshipTarget().add(target);
                }
            } else if (ref.startsWith("bean:")) {
                String refBeanName = ref.substring(5);
                artifactRef = this.findCDIBeanArtifact(refBeanName);
                if (artifactRef != null) {
                    target = new Target();
                    target.setValue(artifactRef.getUuid());
                    relationship.getRelationshipTarget().add(target);
                }
            } else if (ref.startsWith("xslt:")) {
                String refXsltFile = ref.substring(5);
                artifactRef = this.findXsltArtifact(refXsltFile);
                if (artifactRef != null) {
                    target = new Target();
                    target.setValue(artifactRef.getUuid());
                    relationship.getRelationshipTarget().add(target);
                }
            } else if (ref.startsWith("smooks:")) {
                String smooksConfig = ref.substring(7);
                artifactRef = this.findSmooksArtifact(smooksConfig);
                if (artifactRef != null) {
                    target = new Target();
                    target.setValue(artifactRef.getUuid());
                    relationship.getRelationshipTarget().add(target);
                }
            } else if (ref.startsWith("camel:") && (artifactRef = this.findCamelArtifact(camelPath = ref.substring(6))) != null) {
                target = new Target();
                target.setValue(artifactRef.getUuid());
                relationship.getRelationshipTarget().add(target);
            }
        }
        if ((relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)artifact, (String)"transformsFrom")) != null && relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF)) {
            ref = (String)relationship.getOtherAttributes().remove(SwitchYardXmlDeriver.UNRESOLVED_REF);
            if (ref.startsWith("java:")) {
                refClassName = ref.substring(5);
                artifactRef = this.findJavaClassArtifact(refClassName);
                if (artifactRef != null) {
                    target = new Target();
                    target.setValue(artifactRef.getUuid());
                    relationship.getRelationshipTarget().add(target);
                }
            } else if (ref.startsWith("{") && (artifactRef = this.findElementDeclarationArtifact(refQName = QName.valueOf(ref))) != null) {
                target = new Target();
                target.setValue(artifactRef.getUuid());
                relationship.getRelationshipTarget().add(target);
            }
        }
        if ((relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)artifact, (String)"transformsTo")) != null && relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF)) {
            ref = (String)relationship.getOtherAttributes().remove(SwitchYardXmlDeriver.UNRESOLVED_REF);
            if (ref.startsWith("java:")) {
                refClassName = ref.substring(5);
                artifactRef = this.findJavaClassArtifact(refClassName);
                if (artifactRef != null) {
                    target = new Target();
                    target.setValue(artifactRef.getUuid());
                    relationship.getRelationshipTarget().add(target);
                }
            } else if (ref.startsWith("{") && (artifactRef = this.findElementDeclarationArtifact(refQName = QName.valueOf(ref))) != null) {
                target = new Target();
                target.setValue(artifactRef.getUuid());
                relationship.getRelationshipTarget().add(target);
            }
        }
    }

    @Override
    public void visitValidator(ExtendedArtifactType artifact) {
        Target target;
        BaseArtifactType artifactRef;
        String refClassName;
        String ref;
        Relationship relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)artifact, (String)"implementedBy");
        if (relationship != null && relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF)) {
            String refBeanName;
            ref = (String)relationship.getOtherAttributes().remove(SwitchYardXmlDeriver.UNRESOLVED_REF);
            if (ref.startsWith("class:")) {
                refClassName = ref.substring(6);
                artifactRef = this.findJavaClassArtifact(refClassName);
                if (artifactRef != null) {
                    target = new Target();
                    target.setValue(artifactRef.getUuid());
                    relationship.getRelationshipTarget().add(target);
                }
            } else if (ref.startsWith("bean:") && (artifactRef = this.findCDIBeanArtifact(refBeanName = ref.substring(5))) != null) {
                target = new Target();
                target.setValue(artifactRef.getUuid());
                relationship.getRelationshipTarget().add(target);
            }
        }
        if ((relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)artifact, (String)"validates")) != null && relationship.getOtherAttributes().containsKey(SwitchYardXmlDeriver.UNRESOLVED_REF)) {
            QName refQName;
            ref = (String)relationship.getOtherAttributes().remove(SwitchYardXmlDeriver.UNRESOLVED_REF);
            if (ref.startsWith("java:")) {
                refClassName = ref.substring(5);
                artifactRef = this.findJavaClassArtifact(refClassName);
                if (artifactRef != null) {
                    target = new Target();
                    target.setValue(artifactRef.getUuid());
                    relationship.getRelationshipTarget().add(target);
                }
            } else if (ref.startsWith("{") && (artifactRef = this.findElementDeclarationArtifact(refQName = QName.valueOf(ref))) != null) {
                target = new Target();
                target.setValue(artifactRef.getUuid());
                relationship.getRelationshipTarget().add(target);
            }
        }
    }

    private BaseArtifactType findJavaClassArtifact(String className) {
        int idx = className.lastIndexOf(46);
        String packageName = className.substring(0, idx);
        String shortName = className.substring(idx + 1);
        LinkerContext context = linkerContext.get();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("packageName", packageName);
        criteria.put("className", shortName);
        Collection artifacts = context.findArtifacts("ext", "JavaClass", criteria);
        if (artifacts != null && !artifacts.isEmpty()) {
            return (BaseArtifactType)artifacts.iterator().next();
        }
        log.debug("No java class found for: " + className);
        return null;
    }

    private BaseArtifactType findJavaInterfaceArtifact(String interfaceName) {
        int idx = interfaceName.lastIndexOf(46);
        String packageName = interfaceName.substring(0, idx);
        String shortName = interfaceName.substring(idx + 1);
        LinkerContext context = linkerContext.get();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("packageName", packageName);
        criteria.put("className", shortName);
        Collection artifacts = context.findArtifacts("ext", "JavaInterface", criteria);
        if (artifacts != null && !artifacts.isEmpty()) {
            return (BaseArtifactType)artifacts.iterator().next();
        }
        log.debug("No java interface found for: " + interfaceName);
        return null;
    }

    private BaseArtifactType findElementDeclarationArtifact(QName refQName) {
        LinkerContext context = linkerContext.get();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("namespace", refQName.getNamespaceURI());
        criteria.put("ncName", refQName.getLocalPart());
        Collection artifacts = context.findArtifacts(ArtifactTypeEnum.ElementDeclaration.getModel(), ArtifactTypeEnum.ElementDeclaration.getType(), criteria);
        if (artifacts != null && !artifacts.isEmpty()) {
            return (BaseArtifactType)artifacts.iterator().next();
        }
        log.debug("No element declaration found for: " + refQName);
        return null;
    }

    private BaseArtifactType findSmooksArtifact(String smooksConfig) {
        return null;
    }

    private BaseArtifactType findCamelArtifact(String camelXmlPath) {
        return null;
    }

    private BaseArtifactType findXsltArtifact(String xsltFile) {
        return null;
    }

    private BaseArtifactType findCDIBeanArtifact(String beanName) {
        return null;
    }

    private BaseArtifactType findWsdlArtifact(String refWsdl) {
        return null;
    }

    public void link(LinkerContext context, ExtendedArtifactType derivedArtifact) {
        linkerContext.set(context);
        SwitchYardArtifactVisitorHelper.visitArtifact(derivedArtifact, this);
    }
}

