/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.switchyard.deriver;

import java.io.IOException;
import java.util.Collection;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.derived.AbstractXmlDeriver;
import org.overlord.sramp.common.derived.LinkerContext;
import org.overlord.sramp.common.query.xpath.StaticNamespaceContext;
import org.overlord.sramp.integration.switchyard.deriver.SwitchYardLinker;
import org.overlord.sramp.integration.switchyard.model.SwitchYardModel;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SwitchYardXmlDeriver
extends AbstractXmlDeriver {
    public static final QName UNRESOLVED_REF = new QName("urn:s-ramp:switchyard-deriver", "unresolvedRef");
    private final SwitchYardLinker linker = new SwitchYardLinker();

    protected void configureNamespaceMappings(StaticNamespaceContext namespaceContext) {
        super.configureNamespaceMappings(namespaceContext);
        SwitchYardModel.addNamespaceMappings(namespaceContext);
    }

    protected void derive(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, Element rootElement, XPath xpath) throws IOException {
        try {
            String targetNS = rootElement.getAttribute("targetNamespace");
            SrampModelUtils.setCustomProperty((BaseArtifactType)artifact, (String)"targetNamespace", (String)targetNS);
            if ("switchyard.xml".equals(artifact.getName()) && rootElement.hasAttribute("name")) {
                String name = rootElement.getAttribute("name");
                artifact.setName(name);
            }
            this.processComponents(derivedArtifacts, artifact, rootElement, xpath);
            this.processServices(derivedArtifacts, artifact, rootElement, xpath);
            this.processTransformers(derivedArtifacts, artifact, rootElement, xpath);
            this.processValidators(derivedArtifacts, artifact, rootElement, xpath);
        }
        catch (XPathExpressionException e) {
            throw new IOException(e);
        }
    }

    private void processServices(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType sourceArtifact, Element rootElement, XPath xpath) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(xpath, rootElement, "./sca:composite/sca:service", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            String promote;
            BaseArtifactType component;
            Element node = (Element)nodes.item(idx);
            String name = node.getAttribute("name");
            ExtendedArtifactType serviceArtifact = SwitchYardModel.newServiceArtifact(name);
            derivedArtifacts.add((BaseArtifactType)serviceArtifact);
            if (!node.hasAttribute("promote") || (component = this.findComponentByName(derivedArtifacts, promote = node.getAttribute("promote"))) == null) continue;
            SrampModelUtils.addGenericRelationship((BaseArtifactType)serviceArtifact, (String)"promotes", (String)component.getUuid());
        }
    }

    private void processComponents(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, Element rootElement, XPath xpath) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(xpath, rootElement, "./sca:composite/sca:component", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element implCamel;
            Element node = (Element)nodes.item(idx);
            String name = node.getAttribute("name");
            ExtendedArtifactType componentArtifact = SwitchYardModel.newComponentArtifact(name);
            derivedArtifacts.add((BaseArtifactType)componentArtifact);
            Element implBean = (Element)this.query(xpath, node, "bean:implementation.bean", XPathConstants.NODE);
            if (implBean != null) {
                if (implBean.hasAttribute("class")) {
                    String implClassName = implBean.getAttribute("class");
                    Relationship relationship = SrampModelUtils.addGenericRelationship((BaseArtifactType)componentArtifact, (String)"implementedBy", null);
                    relationship.getOtherAttributes().put(UNRESOLVED_REF, "class:" + implClassName);
                }
                if (implBean.hasAttribute("requires")) {
                    String requires = implBean.getAttribute("requires");
                    SrampModelUtils.setCustomProperty((BaseArtifactType)componentArtifact, (String)"requires", (String)requires);
                }
            }
            if ((implCamel = (Element)this.query(xpath, node, "camel:implementation.camel", XPathConstants.NODE)) != null) {
                Element xml = (Element)this.query(xpath, implCamel, "camel:xml", XPathConstants.NODE);
                if (xml != null) {
                    String path = xml.getAttribute("path");
                    Relationship relationship = SrampModelUtils.addGenericRelationship((BaseArtifactType)componentArtifact, (String)"implementedBy", null);
                    relationship.getOtherAttributes().put(UNRESOLVED_REF, "camel:" + path);
                }
                if (implCamel.hasAttribute("requires")) {
                    String requires = implCamel.getAttribute("requires");
                    SrampModelUtils.setCustomProperty((BaseArtifactType)componentArtifact, (String)"requires", (String)requires);
                }
            }
            NodeList refs = (NodeList)this.query(xpath, node, "sca:reference", XPathConstants.NODESET);
            for (int jdx = 0; jdx < refs.getLength(); ++jdx) {
                Relationship relationship;
                Element ref = (Element)refs.item(jdx);
                Element iface = (Element)this.query(xpath, ref, "sca:interface.java", XPathConstants.NODE);
                if (iface != null && iface.hasAttribute("interface")) {
                    String ifaceName = iface.getAttribute("interface");
                    relationship = SrampModelUtils.addGenericRelationship((BaseArtifactType)componentArtifact, (String)"references", null);
                    relationship.getOtherAttributes().put(UNRESOLVED_REF, "java:" + ifaceName);
                }
                if ((iface = (Element)this.query(xpath, ref, "sca:interface.wsdl", XPathConstants.NODE)) == null || !iface.hasAttribute("interface")) continue;
                String wsdlInfo = iface.getAttribute("interface");
                relationship = SrampModelUtils.addGenericRelationship((BaseArtifactType)componentArtifact, (String)"references", null);
                relationship.getOtherAttributes().put(UNRESOLVED_REF, "wsdl:" + wsdlInfo);
            }
        }
    }

    private void processTransformers(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, Element rootElement, XPath xpath) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(xpath, rootElement, "./swyd:transforms/tf:transform.java | ./swyd:transforms/tf:transform.xslt | ./swyd:transforms/tf:transform.json | ./swyd:transforms/tf:transform.smooks | ./swyd:transforms/tf:transform.jaxb", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Relationship relationship;
            Element node = (Element)nodes.item(idx);
            String name = node.getAttribute("name");
            if (name == null || name.trim().length() == 0) {
                if (node.hasAttribute("from") && node.hasAttribute("to")) {
                    String from = node.getAttribute("from");
                    String to = node.getAttribute("to");
                    if (from.startsWith("{")) {
                        name = from.substring(from.lastIndexOf("}") + 1);
                    } else if (from.startsWith("java:")) {
                        name = from.substring(from.lastIndexOf(46) + 1);
                    }
                    if (to.startsWith("{")) {
                        name = name + "->" + to.substring(to.lastIndexOf("}") + 1);
                    } else if (to.startsWith("java:")) {
                        name = name + "->" + to.substring(from.lastIndexOf(46) + 1);
                    }
                } else {
                    name = node.getLocalName();
                }
            }
            ExtendedArtifactType transformerArtifact = SwitchYardModel.newTransformerArtifact(name);
            String type = node.getLocalName();
            type = type.substring(type.lastIndexOf(46) + 1);
            SrampModelUtils.setCustomProperty((BaseArtifactType)transformerArtifact, (String)"transformer-type", (String)type);
            if (node.hasAttribute("class")) {
                relationship = SrampModelUtils.addGenericRelationship((BaseArtifactType)transformerArtifact, (String)"implementedBy", null);
                relationship.getOtherAttributes().put(UNRESOLVED_REF, "class:" + node.getAttribute("class"));
            }
            if (node.hasAttribute("bean")) {
                relationship = SrampModelUtils.addGenericRelationship((BaseArtifactType)transformerArtifact, (String)"implementedBy", null);
                relationship.getOtherAttributes().put(UNRESOLVED_REF, "bean:" + node.getAttribute("bean"));
            }
            if (node.hasAttribute("xsltFile")) {
                relationship = SrampModelUtils.addGenericRelationship((BaseArtifactType)transformerArtifact, (String)"implementedBy", null);
                relationship.getOtherAttributes().put(UNRESOLVED_REF, "xslt:" + node.getAttribute("xsltFile"));
            }
            if (node.hasAttribute("config")) {
                relationship = SrampModelUtils.addGenericRelationship((BaseArtifactType)transformerArtifact, (String)"implementedBy", null);
                relationship.getOtherAttributes().put(UNRESOLVED_REF, "smooks:" + node.getAttribute("config"));
            }
            if (node.hasAttribute("from")) {
                relationship = SrampModelUtils.addGenericRelationship((BaseArtifactType)transformerArtifact, (String)"transformsFrom", null);
                relationship.getOtherAttributes().put(UNRESOLVED_REF, node.getAttribute("from"));
            }
            if (node.hasAttribute("to")) {
                relationship = SrampModelUtils.addGenericRelationship((BaseArtifactType)transformerArtifact, (String)"transformsTo", null);
                relationship.getOtherAttributes().put(UNRESOLVED_REF, node.getAttribute("to"));
            }
            derivedArtifacts.add((BaseArtifactType)transformerArtifact);
        }
    }

    private void processValidators(Collection<BaseArtifactType> derivedArtifacts, BaseArtifactType artifact, Element rootElement, XPath xpath) throws XPathExpressionException {
        NodeList nodes = (NodeList)this.query(xpath, rootElement, "./swyd:validates/val:validate.java | ./swyd:validates/val:validate.xml", XPathConstants.NODESET);
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element node = (Element)nodes.item(idx);
            if (!node.hasAttribute("name")) continue;
            String name = node.getAttribute("name");
            ExtendedArtifactType validatorArtifact = SwitchYardModel.newValidateArtifact(name);
            String type = node.getLocalName();
            type = type.substring(type.lastIndexOf(46) + 1);
            SrampModelUtils.setCustomProperty((BaseArtifactType)validatorArtifact, (String)"validator-type", (String)type);
            Relationship relationship = SrampModelUtils.addGenericRelationship((BaseArtifactType)validatorArtifact, (String)"validates", null);
            relationship.getOtherAttributes().put(UNRESOLVED_REF, name);
            if (node.hasAttribute("class")) {
                relationship = SrampModelUtils.addGenericRelationship((BaseArtifactType)validatorArtifact, (String)"implementedBy", null);
                relationship.getOtherAttributes().put(UNRESOLVED_REF, "class:" + node.getAttribute("class"));
            }
            if (node.hasAttribute("bean")) {
                relationship = SrampModelUtils.addGenericRelationship((BaseArtifactType)validatorArtifact, (String)"implementedBy", null);
                relationship.getOtherAttributes().put(UNRESOLVED_REF, "bean:" + node.getAttribute("bean"));
            }
            if (node.hasAttribute("schemaType")) {
                // empty if block
            }
            derivedArtifacts.add((BaseArtifactType)validatorArtifact);
        }
    }

    public void link(LinkerContext context, BaseArtifactType sourceArtifact, Collection<BaseArtifactType> derivedArtifacts) {
        for (BaseArtifactType derivedArtifact : derivedArtifacts) {
            this.linker.link(context, (ExtendedArtifactType)derivedArtifact);
        }
    }

    private BaseArtifactType findComponentByName(Collection<BaseArtifactType> derivedArtifacts, String componentName) {
        for (BaseArtifactType artifact : derivedArtifacts) {
            ArtifactType at = ArtifactType.valueOf((BaseArtifactType)artifact);
            if (!at.getType().equals("SwitchYardComponent") || !artifact.getName().equals(componentName)) continue;
            return artifact;
        }
        return null;
    }
}

