/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.switchyard.model;

import java.util.UUID;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedArtifactType;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.query.xpath.StaticNamespaceContext;

public class SwitchYardModel {
    public static final String SCA_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    public static final String SWITCHYARD_NS = "urn:switchyard-config:switchyard:1.0";
    public static final String BEAN_NS = "urn:switchyard-component-bean:config:1.0";
    public static final String TRANSFORM_NS = "urn:switchyard-config:transform:1.0";
    public static final String VALIDATE_NS = "urn:switchyard-config:validate:1.0";
    public static final String SOAP_NS = "urn:switchyard-component-soap:config:1.0";
    public static final String CAMEL_NS = "urn:switchyard-component-camel:config:1.0";
    public static final String REL_IMPLEMENTS = "implements";
    public static final String REL_PROMOTES = "promotes";
    public static final String REL_USES = "uses";
    public static final String REL_TRANSFORMS_FROM = "transformsFrom";
    public static final String REL_TRANSFORMS_TO = "transformsTo";
    public static final String REL_IMPLEMENTED_BY = "implementedBy";
    public static final String REL_REFERENCES = "references";
    public static final String REL_VALIDATES = "validates";
    public static final String PROP_TRANSFORMER_TYPE = "transformer-type";
    public static final String PROP_VALIDATE_TYPE = "validator-type";
    public static final String PROP_GATEWAY_TYPE = "gateway-type";
    public static final String SwitchYardXmlDocument = "SwitchYardXmlDocument";
    public static final ArtifactType SwitchYardXmlDocumentType = ArtifactType.valueOf((String)"SwitchYardXmlDocument");
    public static final String SwitchYardService = "SwitchYardService";
    public static final String SwitchYardComponent = "SwitchYardComponent";
    public static final String SwitchYardTransformer = "SwitchYardTransformer";
    public static final String SwitchYardValidator = "SwitchYardValidator";
    public static final ArtifactType SwitchYardServiceType = ArtifactType.valueOf((String)"SwitchYardService");
    public static final ArtifactType SwitchYardComponentType = ArtifactType.valueOf((String)"SwitchYardComponent");
    public static final ArtifactType SwitchYardTransformerType = ArtifactType.valueOf((String)"SwitchYardTransformer");
    public static final ArtifactType SwitchYardValidatorType = ArtifactType.valueOf((String)"SwitchYardValidator");

    private static final ExtendedArtifactType newArtifact(String switchYardType, String name) {
        ExtendedArtifactType artifact = new ExtendedArtifactType();
        artifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        artifact.setExtendedType(switchYardType);
        artifact.setUuid(UUID.randomUUID().toString());
        artifact.setName(name);
        return artifact;
    }

    public static final ExtendedArtifactType newServiceArtifact(String name) {
        return SwitchYardModel.newArtifact(SwitchYardService, name);
    }

    public static final ExtendedArtifactType newTransformerArtifact(String name) {
        return SwitchYardModel.newArtifact(SwitchYardTransformer, name);
    }

    public static final ExtendedArtifactType newValidateArtifact(String name) {
        return SwitchYardModel.newArtifact(SwitchYardValidator, name);
    }

    public static final ExtendedArtifactType newComponentArtifact(String name) {
        return SwitchYardModel.newArtifact(SwitchYardComponent, name);
    }

    public static void addNamespaceMappings(StaticNamespaceContext namespaceContext) {
        namespaceContext.addMapping("sca", SCA_NS);
        namespaceContext.addMapping("swyd", SWITCHYARD_NS);
        namespaceContext.addMapping("bean", BEAN_NS);
        namespaceContext.addMapping("tf", TRANSFORM_NS);
        namespaceContext.addMapping("val", VALIDATE_NS);
        namespaceContext.addMapping("soap", SOAP_NS);
        namespaceContext.addMapping("camel", CAMEL_NS);
    }
}

