/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.switchyard.expand;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.overlord.sramp.atom.archive.expand.ArtifactFilter;
import org.overlord.sramp.atom.archive.expand.CandidateArtifact;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchiveContext;
import org.overlord.sramp.integration.switchyard.expand.SwitchYardAppIndex;

public class SwitchYardArtifactFilter
implements ArtifactFilter {
    private static Set<String> validExtensions = new HashSet<String>();
    private static Set<String> exclusions;
    private SwitchYardAppIndex syIndex;

    public void setContext(ZipToSrampArchiveContext context) {
        this.syIndex = (SwitchYardAppIndex)context.get("switchyard.index");
        if (this.syIndex == null) {
            File switchyardXmlFile = context.getJarEntry("META-INF/switchyard.xml");
            if (switchyardXmlFile == null) {
                switchyardXmlFile = context.getJarEntry("WEB-INF/switchyard.xml");
            }
            if (switchyardXmlFile != null) {
                this.syIndex = new SwitchYardAppIndex(switchyardXmlFile);
                context.put("switchyard.index", (Object)switchyardXmlFile);
            }
        }
    }

    public boolean accepts(CandidateArtifact artifact) {
        String name = artifact.getName();
        if (exclusions.contains(name)) {
            return false;
        }
        String ext = null;
        if (name.contains(".")) {
            ext = name.substring(name.lastIndexOf(46) + 1);
        }
        if (validExtensions.contains(ext)) {
            if (this.syIndex == null) {
                return true;
            }
            return this.doIndexedAccept(artifact, ext);
        }
        return false;
    }

    private boolean doIndexedAccept(CandidateArtifact artifact, String extension) {
        if ("class".equals(extension)) {
            String entryPath = artifact.getEntryPath();
            String classname = entryPath.replace('/', '.').replace('\\', '.');
            classname = classname.substring(0, classname.length() - 6);
            return this.syIndex.contains(classname);
        }
        return true;
    }

    static {
        validExtensions.add("xml");
        validExtensions.add("xsd");
        validExtensions.add("wsdl");
        validExtensions.add("wspolicy");
        validExtensions.add("class");
        validExtensions.add("xsl");
        exclusions = new HashSet<String>();
        exclusions.add("pom.xml");
    }
}

