/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.switchyard.artifactbuilder;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Relationship;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Target;
import org.overlord.sramp.common.ArtifactContent;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.artifactbuilder.MockRelationshipContext;
import org.overlord.sramp.common.artifactbuilder.RelationshipContext;
import org.overlord.sramp.integration.switchyard.artifactbuilder.SwitchYardXmlArtifactBuilder;
import org.overlord.sramp.integration.switchyard.model.SwitchYardModel;

public class SwitchYardXmlDeriverTest {
    @Test
    public void testSwitchyardDeriver() throws IOException {
        SwitchYardXmlArtifactBuilder builder = new SwitchYardXmlArtifactBuilder();
        ExtendedDocument artifact = new ExtendedDocument();
        artifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        artifact.setName("switchyard.xml");
        artifact.setExtendedType("SwitchYardXmlDocument");
        InputStream is = this.getClass().getResourceAsStream("switchyard.xml");
        Collection derivedArtifacts = builder.buildArtifacts((BaseArtifactType)artifact, new ArtifactContent("switchyard.xml", is)).getDerivedArtifacts();
        builder.buildRelationships((RelationshipContext)new MockRelationshipContext());
        Assert.assertNotNull((Object)derivedArtifacts);
        Assert.assertEquals((long)12L, (long)derivedArtifacts.size());
        Assert.assertEquals((Object)"orders", (Object)artifact.getName());
        Assert.assertEquals((Object)"urn:switchyard-quickstart:bean-service:0.1.0", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)artifact, (String)"targetNamespace"));
        BaseArtifactType orderService = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardServiceType, "OrderService");
        Assert.assertNotNull((Object)orderService);
        Assert.assertEquals((Object)"OrderService", (Object)orderService.getName());
        Relationship relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)orderService, (String)"implements");
        Assert.assertNotNull((Object)relationship);
        BaseArtifactType inventoryServiceComponent = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardComponentType, "InventoryService");
        Assert.assertNotNull((Object)inventoryServiceComponent);
        Assert.assertEquals((Object)"managedTransaction.Global", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)inventoryServiceComponent, (String)"requires"));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)inventoryServiceComponent, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)inventoryServiceComponent, (String)"references");
        Assert.assertNull((Object)relationship);
        BaseArtifactType orderServiceComponent = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardComponentType, "OrderService");
        Assert.assertNotNull((Object)orderServiceComponent);
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)orderServiceComponent, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)orderServiceComponent, (String)"references");
        Assert.assertNotNull((Object)relationship);
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)orderService, (String)"promotes");
        Assert.assertNotNull((Object)relationship);
        Assert.assertNotNull((Object)relationship.getRelationshipTarget());
        Assert.assertEquals((Object)orderServiceComponent.getUuid(), (Object)((Target)relationship.getRelationshipTarget().iterator().next()).getValue());
        BaseArtifactType camelServiceComponent = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardComponentType, "CamelService");
        Assert.assertNotNull((Object)camelServiceComponent);
        Assert.assertEquals((Object)"noManagedTransaction", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)camelServiceComponent, (String)"requires"));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)camelServiceComponent, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertTrue((boolean)relationship.getRelationshipTarget().isEmpty());
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)camelServiceComponent, (String)"references");
        Assert.assertNull((Object)relationship);
        BaseArtifactType inventoryServiceComponentSvc = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardComponentServiceType, "InventoryService");
        Assert.assertNotNull((Object)camelServiceComponent);
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)inventoryServiceComponentSvc, (String)"implements");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((Object)"propagatesTransaction", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)inventoryServiceComponentSvc, (String)"requires"));
        BaseArtifactType transformJava = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardTransformerType, "OrderAck->submitOrderResponse");
        Assert.assertNotNull((Object)transformJava);
        Assert.assertEquals((Object)"java", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)transformJava, (String)"transformer-type"));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsFrom");
        Assert.assertNotNull((Object)relationship);
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsTo");
        Assert.assertNotNull((Object)relationship);
        BaseArtifactType transformXslt = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardTransformerType, "CDM->S1");
        Assert.assertNotNull((Object)transformXslt);
        Assert.assertEquals((Object)"xslt", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)transformXslt, (String)"transformer-type"));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformXslt, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsFrom");
        Assert.assertNotNull((Object)relationship);
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsTo");
        Assert.assertNotNull((Object)relationship);
        BaseArtifactType validateJava = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardValidatorType, "java:org.switchyard.quickstarts.bean.service.Order");
        Assert.assertNotNull((Object)validateJava);
        Assert.assertEquals((Object)"java", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)validateJava, (String)"validator-type"));
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)validateJava, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)validateJava, (String)"validates");
        Assert.assertNotNull((Object)relationship);
        inventoryServiceComponent = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardComponentType, "InventoryService");
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)inventoryServiceComponent, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)inventoryServiceComponent, (String)"references");
        Assert.assertNull((Object)relationship);
        orderServiceComponent = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardComponentType, "OrderService");
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)orderServiceComponent, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)orderServiceComponent, (String)"references");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        camelServiceComponent = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardComponentType, "CamelService");
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)camelServiceComponent, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        transformJava = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardTransformerType, "OrderAck->submitOrderResponse");
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsFrom");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsTo");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        transformXslt = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardTransformerType, "CDM->S1");
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformXslt, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsFrom");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)transformJava, (String)"transformsTo");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
        validateJava = this.getDerivedArtifact(derivedArtifacts, SwitchYardModel.SwitchYardValidatorType, "java:org.switchyard.quickstarts.bean.service.Order");
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)validateJava, (String)"implementedBy");
        Assert.assertNotNull((Object)relationship);
        relationship = SrampModelUtils.getGenericRelationship((BaseArtifactType)validateJava, (String)"validates");
        Assert.assertNotNull((Object)relationship);
        Assert.assertEquals((long)1L, (long)relationship.getRelationshipTarget().size());
    }

    private BaseArtifactType getDerivedArtifact(Collection<BaseArtifactType> derivedArtifacts, ArtifactType artifactType, String name) {
        for (BaseArtifactType artifact : derivedArtifacts) {
            ArtifactType at = ArtifactType.valueOf((BaseArtifactType)artifact);
            if (!at.equals((Object)artifactType) || !artifact.getName().equals(name)) continue;
            return artifact;
        }
        return null;
    }
}

