/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.teiid.expand;

import java.io.File;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchive;
import org.overlord.sramp.atom.archive.expand.ZipToSrampArchiveException;
import org.overlord.sramp.atom.archive.expand.registry.TypeHintInfo;
import org.overlord.sramp.atom.archive.expand.registry.ZipToSrampArchiveProvider;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.integration.teiid.expand.VdbToSrampArchive;
import org.overlord.sramp.integration.teiid.model.Vdb;

public final class VdbToSrampArchiveProvider
implements ZipToSrampArchiveProvider {
    private static final Map<String, String> hintsMap;

    public boolean accept(ArtifactType artifactType) {
        return artifactType.isExtendedType() && Vdb.ARTIFACT_TYPE.equals(artifactType.getExtendedType());
    }

    public ZipToSrampArchive createExtractor(ArtifactType artifactType, File vdbFile) throws ZipToSrampArchiveException {
        return new VdbToSrampArchive(vdbFile);
    }

    public ZipToSrampArchive createExtractor(ArtifactType artifactType, InputStream vdbStream) throws ZipToSrampArchiveException {
        return new VdbToSrampArchive(vdbStream);
    }

    public TypeHintInfo getArchiveTypeHints() {
        return new TypeHintInfo(Integer.valueOf(30), hintsMap);
    }

    static {
        TreeMap<String, String> aMap = new TreeMap<String, String>();
        aMap.put("META-INF/vdb.xml", Vdb.ARTIFACT_TYPE);
        hintsMap = Collections.unmodifiableMap(aMap);
    }
}

