/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.teiid.deriver;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.overlord.sramp.common.derived.AbstractXmlDeriver;
import org.overlord.sramp.integration.teiid.deriver.ModelDeriver;
import org.overlord.sramp.integration.teiid.deriver.TeiidIntegrationTest;
import org.overlord.sramp.integration.teiid.model.TeiidModel;

public final class ModelDeriverTest
extends TeiidIntegrationTest {
    private AbstractXmlDeriver deriver = null;
    private ExtendedDocument modelArtifact = null;

    @Before
    public void constructDeriver() {
        this.deriver = new ModelDeriver();
        this.modelArtifact = new ExtendedDocument();
        this.modelArtifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        this.modelArtifact.setName("vdb.xml");
        this.modelArtifact.setExtendedType(TeiidModel.ARTIFACT_TYPE.extendedType());
    }

    @Test
    public void shouldDeriveBooksOracleModel() throws Exception {
        InputStream modelStream = this.getResourceAsStream("Books_Oracle.xmi");
        Assert.assertThat((Object)modelStream, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
        Collection derivedArtifacts = this.deriver.derive((BaseArtifactType)this.modelArtifact, modelStream);
        this.deriver.link(null, (BaseArtifactType)this.modelArtifact, derivedArtifacts);
        this.assertPropertyValue((BaseArtifactType)this.modelArtifact, "mmuuid", "mmuuid:18b6c0ff-aa2a-409b-87f2-c3f1cd742b41");
        this.assertPropertyValue((BaseArtifactType)this.modelArtifact, "description", "This is a source model");
        this.assertPropertyValue((BaseArtifactType)this.modelArtifact, "primaryMetamodelUri", "http://www.metamatrix.com/metamodels/Relational");
        this.assertPropertyValue((BaseArtifactType)this.modelArtifact, "modelType", "PHYSICAL");
        this.assertPropertyValue((BaseArtifactType)this.modelArtifact, "maxSetSize", "1000");
        this.assertPropertyValue((BaseArtifactType)this.modelArtifact, "producerName", "Teiid Designer");
        this.assertPropertyValue((BaseArtifactType)this.modelArtifact, "producerVersion", "8.0.0");
    }

    @Test(expected=IOException.class)
    public void shouldNotDeriveNonModels() throws Exception {
        InputStream notAModelStream = this.getResourceAsStream("twitterVdb.xml");
        Assert.assertThat((Object)notAModelStream, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
        this.deriver.derive((BaseArtifactType)this.modelArtifact, notAModelStream);
    }
}

