/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.teiid.deriver;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactEnum;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.overlord.sramp.common.derived.AbstractXmlDeriver;
import org.overlord.sramp.integration.teiid.deriver.TeiidIntegrationTest;
import org.overlord.sramp.integration.teiid.deriver.VdbManifestDeriver;
import org.overlord.sramp.integration.teiid.model.TeiidExtendedType;
import org.overlord.sramp.integration.teiid.model.VdbDataPolicy;
import org.overlord.sramp.integration.teiid.model.VdbEntry;
import org.overlord.sramp.integration.teiid.model.VdbImport;
import org.overlord.sramp.integration.teiid.model.VdbManifest;
import org.overlord.sramp.integration.teiid.model.VdbPermission;
import org.overlord.sramp.integration.teiid.model.VdbSchema;
import org.overlord.sramp.integration.teiid.model.VdbSchemaSource;
import org.overlord.sramp.integration.teiid.model.VdbTranslator;
import org.overlord.sramp.integration.teiid.model.VdbValidationError;

public final class VdbManifestDeriverTest
extends TeiidIntegrationTest {
    private AbstractXmlDeriver deriver = null;
    private ExtendedDocument vdbManifestArtifact = null;

    @Before
    public void constructDeriver() {
        this.deriver = new VdbManifestDeriver();
        this.vdbManifestArtifact = new ExtendedDocument();
        this.vdbManifestArtifact.setArtifactType(BaseArtifactEnum.EXTENDED_ARTIFACT_TYPE);
        this.vdbManifestArtifact.setName("vdb.xml");
        this.vdbManifestArtifact.setExtendedType(VdbManifest.ARTIFACT_TYPE.extendedType());
    }

    @Test
    public void shouldDeriveParserParserTestVdbArtifacts() throws Exception {
        InputStream vdbStream = this.getResourceAsStream("parser-test-vdb.xml");
        Assert.assertThat((Object)vdbStream, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
        Collection derivedArtifacts = this.deriver.derive((BaseArtifactType)this.vdbManifestArtifact, vdbStream);
        this.deriver.link(null, (BaseArtifactType)this.vdbManifestArtifact, derivedArtifacts);
        Assert.assertThat((Object)this.vdbManifestArtifact.getName(), (Matcher)Is.is((Object)"myVDB"));
        Assert.assertThat((Object)this.vdbManifestArtifact.getDescription(), (Matcher)Is.is((Object)"vdb description"));
        Assert.assertThat((Object)this.vdbManifestArtifact.getVersion(), (Matcher)Is.is((Object)"3"));
        this.assertPropertyValue((BaseArtifactType)this.vdbManifestArtifact, "vdbVersion", "3");
        this.assertPropertyValue((BaseArtifactType)this.vdbManifestArtifact, "vdb-property2", "vdb-value2");
        this.assertPropertyValue((BaseArtifactType)this.vdbManifestArtifact, "vdb-property", "vdb-value");
        Assert.assertThat((Object)derivedArtifacts.size(), (Matcher)Is.is((Object)14));
        boolean foundImportVdb = false;
        boolean foundPhysicalModel = false;
        boolean foundSource1 = false;
        boolean foundError = false;
        boolean foundVirtualModel = false;
        boolean foundSource2 = false;
        boolean foundSource3 = false;
        boolean foundEntry1 = false;
        boolean foundEntry2 = false;
        boolean foundTranslator = false;
        boolean foundDataRole = false;
        boolean foundPermission1 = false;
        boolean foundPermission2 = false;
        boolean foundPermission3 = false;
        BaseArtifactType importVdb = null;
        BaseArtifactType physicalModel = null;
        BaseArtifactType virtualModel = null;
        BaseArtifactType source1 = null;
        BaseArtifactType source2 = null;
        BaseArtifactType source3 = null;
        BaseArtifactType dataPolicy = null;
        BaseArtifactType permission1 = null;
        BaseArtifactType permission2 = null;
        BaseArtifactType permission3 = null;
        BaseArtifactType validationError = null;
        for (BaseArtifactType derivedArtifact : derivedArtifacts) {
            List relationships;
            String artifactName = derivedArtifact.getName();
            if (!foundImportVdb && this.isExtendedType(derivedArtifact, (TeiidExtendedType)VdbImport.ARTIFACT_TYPE)) {
                foundImportVdb = true;
                importVdb = derivedArtifact;
                Assert.assertThat((Object)importVdb.getName(), (Matcher)Is.is((Object)"x"));
                Assert.assertThat((Object)importVdb.getVersion(), (Matcher)Is.is((Object)"2"));
                this.assertPropertyValue(importVdb, "vdbVersion", "2");
                this.assertPropertyValue(importVdb, "importDataPolicies", "true");
                Assert.assertThat((Object)importVdb.getProperty().size(), (Matcher)Is.is((Object)2));
                relationships = derivedArtifact.getRelationship();
                Assert.assertThat((Object)relationships.size(), (Matcher)Is.is((Object)1));
                this.assertRelationshipTargetUuid((BaseArtifactType)this.vdbManifestArtifact, VdbManifest.CONTAINS_RELATIONSHIP, derivedArtifact.getUuid());
                continue;
            }
            if (!foundTranslator && this.isExtendedType(derivedArtifact, VdbTranslator.ARTIFACT_TYPE)) {
                foundTranslator = true;
                Assert.assertThat((Object)artifactName, (Matcher)Is.is((Object)"oracleOverride"));
                Assert.assertThat((Object)derivedArtifact.getDescription(), (Matcher)Is.is((Object)"hello world"));
                Assert.assertThat((Object)derivedArtifact.getProperty().size(), (Matcher)Is.is((Object)2));
                this.assertPropertyValue(derivedArtifact, "translatorType", "oracle");
                this.assertPropertyValue(derivedArtifact, "my-property", "my-value");
                relationships = derivedArtifact.getRelationship();
                Assert.assertThat((Object)relationships.size(), (Matcher)Is.is((Object)1));
                this.assertRelationshipTargetUuid((BaseArtifactType)this.vdbManifestArtifact, VdbManifest.CONTAINS_RELATIONSHIP, derivedArtifact.getUuid());
                continue;
            }
            if (this.isExtendedType(derivedArtifact, (TeiidExtendedType)VdbEntry.ARTIFACT_TYPE)) {
                if (!foundEntry1 && "/path-one".equals(artifactName)) {
                    foundEntry1 = true;
                    Assert.assertThat((Object)derivedArtifact.getDescription(), (Matcher)Is.is((Object)"path one description"));
                    this.assertPropertyValue(derivedArtifact, "entryone", "1");
                    Assert.assertThat((Object)derivedArtifact.getProperty().size(), (Matcher)Is.is((Object)1));
                    relationships = derivedArtifact.getRelationship();
                    Assert.assertThat((Object)relationships.size(), (Matcher)Is.is((Object)1));
                    this.assertRelationshipTargetUuid((BaseArtifactType)this.vdbManifestArtifact, VdbManifest.CONTAINS_RELATIONSHIP, derivedArtifact.getUuid());
                    continue;
                }
                if (!foundEntry2 && "/path-two".equals(artifactName)) {
                    foundEntry2 = true;
                    Assert.assertThat((Object)derivedArtifact.getProperty().isEmpty(), (Matcher)Is.is((Object)true));
                    relationships = derivedArtifact.getRelationship();
                    Assert.assertThat((Object)relationships.size(), (Matcher)Is.is((Object)1));
                    this.assertRelationshipTargetUuid((BaseArtifactType)this.vdbManifestArtifact, VdbManifest.CONTAINS_RELATIONSHIP, derivedArtifact.getUuid());
                    continue;
                }
                Assert.fail((String)("unexpected entry: " + artifactName));
                continue;
            }
            if (this.isExtendedType(derivedArtifact, VdbSchema.ARTIFACT_TYPE)) {
                if (!foundPhysicalModel && "model-one".equals(artifactName)) {
                    foundPhysicalModel = true;
                    physicalModel = derivedArtifact;
                    this.assertPropertyValue(physicalModel, "schemaType", VdbSchema.Type.PHYSICAL.name());
                    this.assertPropertyValue(physicalModel, "visible", "false");
                    Assert.assertThat((Object)physicalModel.getDescription(), (Matcher)Is.is((Object)"model description"));
                    this.assertPropertyValue(physicalModel, "model-prop", "model-value-override");
                    relationships = physicalModel.getRelationship();
                    Assert.assertThat((Object)relationships.size(), (Matcher)Is.is((Object)3));
                    this.assertRelationshipTargetUuid((BaseArtifactType)this.vdbManifestArtifact, VdbManifest.CONTAINS_RELATIONSHIP, physicalModel.getUuid());
                    continue;
                }
                if (!foundVirtualModel && "model-two".equals(artifactName)) {
                    foundVirtualModel = true;
                    virtualModel = derivedArtifact;
                    this.assertPropertyValue(virtualModel, "schemaType", VdbSchema.Type.VIRTUAL.name());
                    this.assertPropertyValue(virtualModel, "visible", "true");
                    this.assertPropertyValue(virtualModel, "model-prop", "model-value");
                    this.assertPropertyValue(virtualModel, "metadataType", VdbSchema.DEFAULT_METADATA_TYPE.name());
                    this.assertPropertyValue(virtualModel, "metadata", "DDL Here");
                    relationships = virtualModel.getRelationship();
                    Assert.assertThat((Object)relationships.size(), (Matcher)Is.is((Object)2));
                    this.assertRelationshipTargetUuid((BaseArtifactType)this.vdbManifestArtifact, VdbManifest.CONTAINS_RELATIONSHIP, virtualModel.getUuid());
                    continue;
                }
                Assert.fail((String)("unexpected model: " + artifactName));
                continue;
            }
            if (this.isExtendedType(derivedArtifact, VdbSchemaSource.ARTIFACT_TYPE)) {
                if (!foundSource1 && "s1".equals(artifactName)) {
                    foundSource1 = true;
                    source1 = derivedArtifact;
                    this.assertPropertyValue(source1, "translatorName", "translator");
                    this.assertPropertyValue(source1, "jndiName", "java:binding-one");
                    Assert.assertThat((Object)source1.getProperty().size(), (Matcher)Is.is((Object)2));
                    relationships = source1.getRelationship();
                    Assert.assertThat((Object)relationships.size(), (Matcher)Is.is((Object)2));
                    continue;
                }
                if (!foundSource2 && "s2".equals(artifactName)) {
                    foundSource2 = true;
                    source2 = derivedArtifact;
                    this.assertPropertyValue(source2, "translatorName", "translator");
                    this.assertPropertyValue(source2, "jndiName", "java:binding-two");
                    Assert.assertThat((Object)source2.getProperty().size(), (Matcher)Is.is((Object)2));
                    relationships = source2.getRelationship();
                    Assert.assertThat((Object)relationships.size(), (Matcher)Is.is((Object)2));
                    continue;
                }
                if (!foundSource3 && "s3".equals(artifactName)) {
                    foundSource3 = true;
                    source3 = derivedArtifact;
                    this.assertPropertyValue(source3, "translatorName", "translator");
                    this.assertPropertyValue(source3, "jndiName", "java:mybinding");
                    Assert.assertThat((Object)source3.getProperty().size(), (Matcher)Is.is((Object)2));
                    relationships = source3.getRelationship();
                    Assert.assertThat((Object)relationships.size(), (Matcher)Is.is((Object)2));
                    continue;
                }
                Assert.fail((String)("unexpected source: " + artifactName));
                continue;
            }
            if (!foundDataRole && this.isExtendedType(derivedArtifact, VdbDataPolicy.ARTIFACT_TYPE)) {
                foundDataRole = true;
                dataPolicy = derivedArtifact;
                Assert.assertThat((Object)artifactName, (Matcher)Is.is((Object)"roleOne"));
                Assert.assertThat((Object)dataPolicy.getDescription(), (Matcher)Is.is((Object)"roleOne described"));
                this.assertPropertyValue(dataPolicy, "anyAuthenticated", "false");
                this.assertPropertyValue(dataPolicy, "tempTableCreatable", "true");
                this.assertPropertyValue(dataPolicy, "roleNames", "ROLE1,ROLE2");
                Assert.assertThat((Object)dataPolicy.getProperty().size(), (Matcher)Is.is((Object)3));
                relationships = dataPolicy.getRelationship();
                Assert.assertThat((Object)relationships.size(), (Matcher)Is.is((Object)2));
                this.assertRelationshipTargetUuid((BaseArtifactType)this.vdbManifestArtifact, VdbManifest.CONTAINS_RELATIONSHIP, dataPolicy.getUuid());
                continue;
            }
            if (this.isExtendedType(derivedArtifact, VdbPermission.ARTIFACT_TYPE)) {
                if (!foundPermission1 && "myTable.T1".equals(artifactName)) {
                    foundPermission1 = true;
                    permission1 = derivedArtifact;
                    this.assertPropertyValue(permission1, "readable", "true");
                    Assert.assertThat((Object)permission1.getProperty().size(), (Matcher)Is.is((Object)1));
                    relationships = permission1.getRelationship();
                    Assert.assertThat((Object)relationships.size(), (Matcher)Is.is((Object)2));
                    continue;
                }
                if (!foundPermission2 && "myTable.T2".equals(artifactName)) {
                    foundPermission2 = true;
                    permission2 = derivedArtifact;
                    this.assertPropertyValue(permission2, "creatable", "true");
                    this.assertPropertyValue(permission2, "readable", "false");
                    this.assertPropertyValue(permission2, "updatable", "true");
                    this.assertPropertyValue(permission2, "deletable", "true");
                    this.assertPropertyValue(permission2, "executable", "true");
                    this.assertPropertyValue(permission2, "alterable", "true");
                    this.assertPropertyValue(permission2, "condition", "col1 = user()");
                    Assert.assertThat((Object)permission2.getProperty().size(), (Matcher)Is.is((Object)7));
                    relationships = permission2.getRelationship();
                    Assert.assertThat((Object)relationships.size(), (Matcher)Is.is((Object)2));
                    continue;
                }
                if (!foundPermission3 && "javascript".equals(artifactName)) {
                    foundPermission3 = true;
                    permission3 = derivedArtifact;
                    this.assertPropertyValue(permission3, "languagable", "true");
                    Assert.assertThat((Object)derivedArtifact.getProperty().size(), (Matcher)Is.is((Object)1));
                    relationships = permission3.getRelationship();
                    Assert.assertThat((Object)relationships.size(), (Matcher)Is.is((Object)2));
                    continue;
                }
                Assert.fail((String)("unexpected permission: " + artifactName));
                continue;
            }
            if (this.isExtendedType(derivedArtifact, VdbValidationError.ARTIFACT_TYPE)) {
                foundError = true;
                validationError = derivedArtifact;
                this.assertPropertyValue(validationError, "severity", "ERROR");
                this.assertPropertyValue(validationError, "message", "There is an error in VDB");
                continue;
            }
            Assert.fail((String)("unexpected artifact: " + artifactName));
        }
        Assert.assertThat((String)("foundImportVdb=" + foundImportVdb + ", foundPhysicalModel=" + foundPhysicalModel + ", foundSource1=" + foundSource1 + ", foundVirtualModel=" + foundVirtualModel + ", foundSource2=" + foundSource2 + ", foundSource3=" + foundSource3 + ", foundEntry1" + foundEntry1 + ", foundEntry2=" + foundEntry2 + ", foundError=" + foundError + ", foundTranslator=" + foundTranslator + ", foundDataRole=" + foundDataRole + ", foundPermission1=" + foundPermission1 + ", foundPermission2=" + foundPermission2 + ", foundPermission3=" + foundPermission3), (Object)(foundImportVdb && foundPhysicalModel && foundSource1 && foundVirtualModel && foundSource2 && foundSource3 && foundEntry1 && foundEntry2 && foundError && foundTranslator && foundDataRole && foundPermission1 && foundPermission2 && foundPermission3 ? 1 : 0), (Matcher)Is.is((Object)true));
        this.assertRelationshipTargetUuid(physicalModel, VdbSchema.SOURCES_RELATIONSHIP, source3.getUuid());
        this.assertRelationshipTargetUuid(source3, VdbSchemaSource.SCHEMA_RELATIONSHIP, physicalModel.getUuid());
        this.assertRelationshipTargetUuid(physicalModel, VdbSchema.VALIDATION_ERRORS_RELATIONSHIP, validationError.getUuid());
        this.assertRelationshipTargetUuid(validationError, VdbValidationError.SOURCE_RELATIONSHIP, physicalModel.getUuid());
        this.assertRelationshipTargetUuid(virtualModel, VdbSchema.SOURCES_RELATIONSHIP, source1.getUuid());
        this.assertRelationshipTargetUuid(source1, VdbSchemaSource.SCHEMA_RELATIONSHIP, virtualModel.getUuid());
        this.assertRelationshipTargetUuid(virtualModel, VdbSchema.SOURCES_RELATIONSHIP, source2.getUuid());
        this.assertRelationshipTargetUuid(source2, VdbSchemaSource.SCHEMA_RELATIONSHIP, virtualModel.getUuid());
        this.assertRelationshipTargetUuid(permission1, VdbPermission.DATA_POLICY_RELATIONSHIP, dataPolicy.getUuid());
        this.assertRelationshipTargetUuid(dataPolicy, VdbDataPolicy.PERMISSIONS_RELATIONSHIP, permission1.getUuid());
        this.assertRelationshipTargetUuid(permission2, VdbPermission.DATA_POLICY_RELATIONSHIP, dataPolicy.getUuid());
        this.assertRelationshipTargetUuid(dataPolicy, VdbDataPolicy.PERMISSIONS_RELATIONSHIP, permission2.getUuid());
        this.assertRelationshipTargetUuid(permission3, VdbPermission.DATA_POLICY_RELATIONSHIP, dataPolicy.getUuid());
        this.assertRelationshipTargetUuid(dataPolicy, VdbDataPolicy.PERMISSIONS_RELATIONSHIP, permission3.getUuid());
    }

    @Test
    public void shouldDeriveProductsVdbArtifacts() throws Exception {
        InputStream vdbStream = this.getResourceAsStream("ProductsSS_VDB.xml");
        Assert.assertThat((Object)vdbStream, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
        Collection derivedArtifacts = this.deriver.derive((BaseArtifactType)this.vdbManifestArtifact, vdbStream);
        this.deriver.link(null, (BaseArtifactType)this.vdbManifestArtifact, derivedArtifacts);
        Assert.assertThat((Object)this.vdbManifestArtifact.getName(), (Matcher)Is.is((Object)"ProductsSS_VDB"));
        Assert.assertThat((Object)this.vdbManifestArtifact.getVersion(), (Matcher)Is.is((Object)"1"));
        this.assertPropertyValue((BaseArtifactType)this.vdbManifestArtifact, "vdbVersion", "1");
        this.assertPropertyValue((BaseArtifactType)this.vdbManifestArtifact, "preview", Boolean.FALSE.toString());
        Assert.assertThat((Object)derivedArtifacts.size(), (Matcher)Is.is((Object)6));
        boolean foundError1 = false;
        boolean foundError2 = false;
        boolean foundError3 = false;
        boolean foundError4 = false;
        BaseArtifactType physicalModel = null;
        BaseArtifactType source = null;
        BaseArtifactType validationError1 = null;
        BaseArtifactType validationError2 = null;
        BaseArtifactType validationError3 = null;
        BaseArtifactType validationError4 = null;
        for (BaseArtifactType derivedArtifact : derivedArtifacts) {
            if (this.isExtendedType(derivedArtifact, VdbSchema.ARTIFACT_TYPE)) {
                physicalModel = derivedArtifact;
                this.assertPropertyValue(physicalModel, "visible", Boolean.TRUE.toString());
                this.assertPropertyValue(physicalModel, "schemaType", VdbSchema.Type.PHYSICAL.name());
                Assert.assertThat((Object)physicalModel.getName(), (Matcher)Is.is((Object)"ProductsSS"));
                this.assertPropertyValue(physicalModel, "pathInVdb", "/TestProducts/ProductsSS.xmi");
                Assert.assertThat((Object)physicalModel.getDescription(), (Matcher)Is.is((Object)"SQL Server products relational model"));
                this.assertPropertyValue(physicalModel, "checksum", "3463730926");
                this.assertPropertyValue(physicalModel, "modelUuid", "mmuuid:99038f39-aaf6-4be5-98e7-cfb2e604424f");
                this.assertPropertyValue(physicalModel, "modelClass", "Relational");
                this.assertPropertyValue(physicalModel, "builtIn", Boolean.FALSE.toString());
                this.assertPropertyValue(physicalModel, "indexName", "4286983813.INDEX");
                continue;
            }
            if (this.isExtendedType(derivedArtifact, VdbValidationError.ARTIFACT_TYPE)) {
                String path = derivedArtifact.getName();
                if (!foundError1 && "/".equals(path)) {
                    foundError1 = true;
                    validationError1 = derivedArtifact;
                    this.assertPropertyValue(validationError1, "severity", "WARNING");
                    this.assertPropertyValue(validationError1, "message", "This is a warning message");
                    continue;
                }
                if (!(foundError2 && foundError3 || !"EMPLOYEE/ID".equals(path))) {
                    if (!foundError2) {
                        foundError2 = true;
                        validationError2 = derivedArtifact;
                        this.assertPropertyValue(validationError2, "severity", "ERROR");
                        this.assertPropertyValue(validationError2, "message", "Error 1");
                        continue;
                    }
                    if (foundError3) continue;
                    foundError3 = true;
                    validationError3 = derivedArtifact;
                    this.assertPropertyValue(validationError3, "severity", "ERROR");
                    this.assertPropertyValue(validationError3, "message", "Error 2");
                    continue;
                }
                if (!foundError4 && "DEPARTMENT/NAME".equals(path)) {
                    foundError4 = true;
                    validationError4 = derivedArtifact;
                    this.assertPropertyValue(validationError4, "severity", "ERROR");
                    this.assertPropertyValue(validationError4, "message", "This is an error message");
                    continue;
                }
                Assert.fail((String)("unexpected validation error artifact '" + derivedArtifact.getName() + '\''));
                continue;
            }
            if (this.isExtendedType(derivedArtifact, VdbSchemaSource.ARTIFACT_TYPE)) {
                source = derivedArtifact;
                Assert.assertThat((Object)source.getName(), (Matcher)Is.is((Object)"ProductsSS"));
                this.assertPropertyValue(source, "translatorName", "sqlserver");
                this.assertPropertyValue(source, "jndiName", "ProductsSS");
                continue;
            }
            Assert.fail((String)("unexpected artifact '" + derivedArtifact.getName() + '\''));
        }
        Assert.assertThat((String)("foundError1=" + foundError1 + ", foundError2=" + foundError2 + ", foundError3=" + foundError3 + ", foundError4=" + foundError4), (Object)(foundError1 && foundError2 && foundError3 && foundError4 ? 1 : 0), (Matcher)Is.is((Object)true));
        this.assertRelationshipTargetUuid(validationError1, VdbValidationError.SOURCE_RELATIONSHIP, physicalModel.getUuid());
        this.assertRelationshipTargetUuid(physicalModel, VdbSchema.VALIDATION_ERRORS_RELATIONSHIP, validationError1.getUuid());
        this.assertRelationshipTargetUuid(validationError2, VdbValidationError.SOURCE_RELATIONSHIP, physicalModel.getUuid());
        this.assertRelationshipTargetUuid(physicalModel, VdbSchema.VALIDATION_ERRORS_RELATIONSHIP, validationError2.getUuid());
        this.assertRelationshipTargetUuid(validationError3, VdbValidationError.SOURCE_RELATIONSHIP, physicalModel.getUuid());
        this.assertRelationshipTargetUuid(physicalModel, VdbSchema.VALIDATION_ERRORS_RELATIONSHIP, validationError3.getUuid());
        this.assertRelationshipTargetUuid(validationError4, VdbValidationError.SOURCE_RELATIONSHIP, physicalModel.getUuid());
        this.assertRelationshipTargetUuid(physicalModel, VdbSchema.VALIDATION_ERRORS_RELATIONSHIP, validationError4.getUuid());
        this.assertRelationshipTargetUuid(physicalModel, VdbSchema.SOURCES_RELATIONSHIP, source.getUuid());
        this.assertRelationshipTargetUuid(source, VdbSchemaSource.SCHEMA_RELATIONSHIP, physicalModel.getUuid());
    }

    @Test
    public void shouldDeriveTwitterVdbArtifacts() throws Exception {
        InputStream vdbStream = this.getResourceAsStream("twitterVdb.xml");
        Assert.assertThat((Object)vdbStream, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
        Collection derivedArtifacts = this.deriver.derive((BaseArtifactType)this.vdbManifestArtifact, vdbStream);
        this.deriver.link(null, (BaseArtifactType)this.vdbManifestArtifact, derivedArtifacts);
        Assert.assertThat((Object)this.vdbManifestArtifact.getName(), (Matcher)Is.is((Object)"twitter"));
        Assert.assertThat((Object)this.vdbManifestArtifact.getDescription(), (Matcher)Is.is((Object)"Shows how to call Web Services"));
        Assert.assertThat((Object)this.vdbManifestArtifact.getVersion(), (Matcher)Is.is((Object)"1"));
        this.assertPropertyValue((BaseArtifactType)this.vdbManifestArtifact, "vdbVersion", "1");
        this.assertPropertyValue((BaseArtifactType)this.vdbManifestArtifact, "UseConnectorMetadata", "cached");
        Assert.assertThat((Object)derivedArtifacts.size(), (Matcher)Is.is((Object)4));
        boolean foundTranslator = false;
        boolean foundPhysicalModel = false;
        boolean foundViewModel = false;
        boolean foundDataSource = false;
        BaseArtifactType sourceArtifact = null;
        BaseArtifactType translatorArtifact = null;
        for (BaseArtifactType derivedArtifact : derivedArtifacts) {
            String artifactName = derivedArtifact.getName();
            if (!foundTranslator && this.isExtendedType(derivedArtifact, VdbTranslator.ARTIFACT_TYPE)) {
                foundTranslator = true;
                translatorArtifact = derivedArtifact;
                Assert.assertThat((Object)artifactName, (Matcher)Is.is((Object)"rest"));
                this.assertPropertyValue(derivedArtifact, "translatorType", "ws");
                this.assertPropertyValue(derivedArtifact, "DefaultBinding", "HTTP");
                this.assertPropertyValue(derivedArtifact, "DefaultServiceMode", "MESSAGE");
                this.assertRelationshipTargetUuid((BaseArtifactType)this.vdbManifestArtifact, VdbManifest.CONTAINS_RELATIONSHIP, derivedArtifact.getUuid());
                continue;
            }
            if (this.isExtendedType(derivedArtifact, VdbSchema.ARTIFACT_TYPE)) {
                if (!foundPhysicalModel && "twitter".equals(artifactName)) {
                    foundPhysicalModel = true;
                    this.assertPropertyValue(derivedArtifact, "schemaType", VdbSchema.Type.PHYSICAL.name());
                    this.assertRelationshipTargetUuid((BaseArtifactType)this.vdbManifestArtifact, VdbManifest.CONTAINS_RELATIONSHIP, derivedArtifact.getUuid());
                    continue;
                }
                if (!foundViewModel && "twitterview".equals(artifactName)) {
                    foundViewModel = true;
                    this.assertPropertyValue(derivedArtifact, "schemaType", VdbSchema.Type.VIRTUAL.name());
                    this.assertPropertyValue(derivedArtifact, "metadataType", VdbSchema.DEFAULT_METADATA_TYPE.name());
                    String expected = "\n             CREATE VIRTUAL PROCEDURE getTweets(query varchar) RETURNS (created_on varchar(25), from_user varchar(25), to_user varchar(25),\n                 profile_image_url varchar(25), source varchar(25), text varchar(140)) AS\n                select tweet.* from\n                    (call twitter.invokeHTTP(action => 'GET', endpoint =>querystring('',query as \"q\"))) w,\n                    XMLTABLE('results' passing JSONTOXML('myxml', w.result) columns\n                    created_on string PATH 'created_at',\n                    from_user string PATH 'from_user',\n                    to_user string PATH 'to_user',\n                    profile_image_url string PATH 'profile_image_url',\n                    source string PATH 'source',\n                    text string PATH 'text') tweet;\n                CREATE VIEW Tweet AS select * FROM twitterview.getTweets;\n         ";
                    this.assertPropertyValue(derivedArtifact, "metadata", "\n             CREATE VIRTUAL PROCEDURE getTweets(query varchar) RETURNS (created_on varchar(25), from_user varchar(25), to_user varchar(25),\n                 profile_image_url varchar(25), source varchar(25), text varchar(140)) AS\n                select tweet.* from\n                    (call twitter.invokeHTTP(action => 'GET', endpoint =>querystring('',query as \"q\"))) w,\n                    XMLTABLE('results' passing JSONTOXML('myxml', w.result) columns\n                    created_on string PATH 'created_at',\n                    from_user string PATH 'from_user',\n                    to_user string PATH 'to_user',\n                    profile_image_url string PATH 'profile_image_url',\n                    source string PATH 'source',\n                    text string PATH 'text') tweet;\n                CREATE VIEW Tweet AS select * FROM twitterview.getTweets;\n         ");
                    this.assertRelationshipTargetUuid((BaseArtifactType)this.vdbManifestArtifact, VdbManifest.CONTAINS_RELATIONSHIP, derivedArtifact.getUuid());
                    continue;
                }
                Assert.fail((String)("unexpected schema artifact '" + artifactName + '\''));
                continue;
            }
            if (!foundDataSource && this.isExtendedType(derivedArtifact, VdbSchemaSource.ARTIFACT_TYPE)) {
                foundDataSource = true;
                sourceArtifact = derivedArtifact;
                Assert.assertThat((Object)artifactName, (Matcher)Is.is((Object)"twitter"));
                this.assertPropertyValue(derivedArtifact, "translatorName", "rest");
                this.assertPropertyValue(derivedArtifact, "jndiName", "java:/twitterDS");
                continue;
            }
            Assert.fail((String)("unexpected artifact '" + artifactName + 39));
        }
        Assert.assertThat((Object)(foundTranslator && foundPhysicalModel && foundViewModel && foundDataSource ? 1 : 0), (Matcher)Is.is((Object)true));
        this.assertRelationshipTargetUuid(sourceArtifact, VdbSchemaSource.TRANSLATOR_RELATIONSHIP, translatorArtifact.getUuid());
        this.assertRelationshipTargetUuid(translatorArtifact, VdbTranslator.SOURCES_RELATIONSHIP, sourceArtifact.getUuid());
    }

    @Test(expected=IOException.class)
    public void shouldNotDeriveNonVdbManifests() throws Exception {
        InputStream notAVdbManifestStream = this.getResourceAsStream("Books_Oracle.xmi");
        Assert.assertThat((Object)notAVdbManifestStream, (Matcher)Is.is((Matcher)IsNot.not((Matcher)IsNull.nullValue())));
        this.deriver.derive((BaseArtifactType)this.vdbManifestArtifact, notAVdbManifestStream);
    }
}

