/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.teiid.model;

import org.overlord.sramp.integration.teiid.Messages;
import org.overlord.sramp.integration.teiid.model.TeiidExtendedType;

public enum TeiidArtifactType implements TeiidExtendedType
{
    MODEL("Model"),
    VDB("Vdb"),
    VDB_MANIFEST("VdbManifest");

    static final String PREFIX = "Teiid";
    private final String extendedType;

    private TeiidArtifactType(String extendedType) {
        this.extendedType = PREFIX + extendedType;
    }

    @Override
    public TeiidExtendedType convert(String proposedExtendedType) {
        for (TeiidArtifactType type : TeiidArtifactType.values()) {
            if (!type.extendedType().equals(proposedExtendedType)) continue;
            return type;
        }
        throw new IllegalArgumentException(Messages.I18N.format("invalidTeiidArtifactType", new Object[]{proposedExtendedType}));
    }

    @Override
    public String extendedType() {
        return this.extendedType;
    }

    @Override
    public boolean isValid(String proposedExtendedType) {
        for (TeiidArtifactType type : TeiidArtifactType.values()) {
            if (!type.extendedType().equals(proposedExtendedType)) continue;
            return true;
        }
        return false;
    }
}

