/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.teiid.model;

import org.overlord.sramp.integration.teiid.Messages;
import org.overlord.sramp.integration.teiid.model.TeiidArtifactType;
import org.overlord.sramp.integration.teiid.model.TeiidExtendedType;

public final class Vdb {
    public static final String ARTIFACT_TYPE = TeiidArtifactType.VDB.extendedType();
    public static final String CONFIGURATION_INFO_FILE_NAME = "ConfigurationInfo.def";
    public static final String DEFAULT_VERSION = "1";
    static final String PREFIX = "TeiidVdb";

    public static enum VdbExtendedType implements TeiidExtendedType
    {
        CONFIG_INFO("ConfigInfo");

        private final String extendedType;

        private VdbExtendedType(String extendedType) {
            this.extendedType = Vdb.PREFIX + extendedType;
        }

        @Override
        public TeiidExtendedType convert(String proposedExtendedType) {
            for (VdbExtendedType type : VdbExtendedType.values()) {
                if (!type.extendedType().equals(proposedExtendedType)) continue;
                return type;
            }
            throw new IllegalArgumentException(Messages.I18N.format("invalidVdbExtendedType", new Object[]{proposedExtendedType}));
        }

        @Override
        public String extendedType() {
            return this.extendedType;
        }

        @Override
        public boolean isValid(String proposedExtendedType) {
            for (VdbExtendedType type : VdbExtendedType.values()) {
                if (!type.extendedType().equals(proposedExtendedType)) continue;
                return true;
            }
            return false;
        }
    }
}

