/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.teiid.artifactbuilder;

import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.artifactbuilder.ArtifactBuilder;
import org.overlord.sramp.common.artifactbuilder.XmlArtifactBuilder;
import org.overlord.sramp.common.query.xpath.StaticNamespaceContext;
import org.overlord.sramp.integration.teiid.Messages;
import org.overlord.sramp.integration.teiid.Utils;
import org.overlord.sramp.integration.teiid.model.TeiidArtifactType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Component(name="Teiid Model Artifact Builder", immediate=true)
@Service(value={ArtifactBuilder.class})
public final class ModelArtifactBuilder
extends XmlArtifactBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelArtifactBuilder.class);

    protected void derive() throws IOException {
        LOGGER.debug("ModelArtifactBuilder element='{}' of artifact '{}'", (Object)this.rootElement.getLocalName(), (Object)this.getPrimaryArtifact().getName());
        if (!(this.getPrimaryArtifact() instanceof ExtendedDocument) || !TeiidArtifactType.MODEL.extendedType().equals(((ExtendedDocument)this.getPrimaryArtifact()).getExtendedType())) {
            throw new IllegalArgumentException(Messages.I18N.format("notModelArtifact", new Object[]{this.getPrimaryArtifact().getName()}));
        }
        try {
            if (!"XMI".equals(this.rootElement.getLocalName())) {
                throw new IllegalArgumentException(Messages.I18N.format("missingModelRootElement", new Object[]{this.getPrimaryArtifact().getName()}));
            }
            this.processModelAnnotation();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void processModelAnnotation() throws Exception {
        Element annotationElement = (Element)this.query(this.rootElement, Utils.getElementQueryString("mmcore:ModelAnnotation"), XPathConstants.NODE);
        if (annotationElement == null) {
            throw new IllegalArgumentException(Messages.I18N.format("missingModelAnnotationElement", new Object[]{this.getPrimaryArtifact().getName()}));
        }
        this.setProperty(annotationElement, "xmi:uuid", "mmuuid");
        this.setProperty(annotationElement, "primaryMetamodelUri", "primaryMetamodelUri");
        this.setProperty(annotationElement, "modelType", "modelType");
        this.setProperty(annotationElement, "ProducerName", "producerName");
        this.setProperty(annotationElement, "ProducerVersion", "producerVersion");
        this.setProperty(annotationElement, "maxSetSize", "maxSetSize");
        this.setProperty(annotationElement, "nameInSource", "nameInSource");
        this.setProperty(annotationElement, "description", "description");
        this.setProperty(annotationElement, "visible", "visible");
    }

    protected void configureNamespaceMappings(StaticNamespaceContext namespaceContext) {
        super.configureNamespaceMappings(namespaceContext);
        NamedNodeMap attributes = this.rootElement.getAttributes();
        int numAttrs = attributes.getLength();
        for (int i = 0; i < numAttrs; ++i) {
            Node attr = attributes.item(i);
            if (!"xmlns".equals(attr.getPrefix())) continue;
            namespaceContext.addMapping(attr.getLocalName(), attr.getNodeValue());
            LOGGER.debug("ModelArtifactBuilder:adding namespace with prefix '{}' and URI '{}'", (Object)attr.getLocalName(), (Object)attr.getNodeValue());
        }
    }

    protected Object query(Element context, String query, QName returnType) throws XPathExpressionException {
        LOGGER.debug("ModelArtifactBuilder:executing query '{}'", (Object)query);
        return super.query(context, query, returnType);
    }

    private void setProperty(Element element, String attributeName, String propertyName) {
        String propValue = element.getAttribute(attributeName);
        SrampModelUtils.setCustomProperty((BaseArtifactType)this.getPrimaryArtifact(), (String)propertyName, (String)propValue);
    }
}

