/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.test.artifacttypedetector;

import org.overlord.sramp.common.ArtifactContent;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.integration.ArchiveContext;
import org.overlord.sramp.integration.artifacttypedetector.AbstractArtifactTypeDetector;
import org.overlord.sramp.integration.teiid.model.TeiidArtifactType;
import org.overlord.sramp.integration.teiid.model.Vdb;

public class TeiidArtifactTypeDetector
extends AbstractArtifactTypeDetector {
    public ArtifactType detect(ArtifactContent content) {
        if ("vdb.xml".equals(content.getFilename())) {
            return ArtifactType.valueOf((String)TeiidArtifactType.VDB_MANIFEST.extendedType(), (boolean)true);
        }
        if (content.getFilename().endsWith(".xmi")) {
            return ArtifactType.valueOf((String)TeiidArtifactType.MODEL.extendedType(), (boolean)true);
        }
        if ("ConfigurationInfo.def".equals(content.getFilename())) {
            return ArtifactType.valueOf((String)Vdb.VdbExtendedType.CONFIG_INFO.extendedType(), (boolean)true);
        }
        return null;
    }

    public ArtifactType detect(ArtifactContent content, ArchiveContext archiveContext) {
        if (archiveContext.isExpandedFromArchive()) {
            return this.detect(content);
        }
        if (archiveContext.hasArchiveEntry("META-INF/vdb.xml")) {
            return ArtifactType.valueOf((String)Vdb.ARTIFACT_TYPE, (boolean)true);
        }
        return null;
    }

    public boolean isArchive(ArtifactContent content) {
        if (content.getFilename().endsWith(".vdb")) {
            return true;
        }
        return super.isArchive(content);
    }

    public boolean allowExpansionFromArchive(ArtifactContent content, ArchiveContext archiveContext) {
        if (content.getFilename().endsWith(".xmi")) {
            return true;
        }
        return super.allowExpansionFromArchive(content, archiveContext);
    }

    public int getPriority() {
        return 2;
    }
}

