/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.artifacttypedetector;

import org.overlord.sramp.common.ArtifactContent;
import org.overlord.sramp.integration.ArchiveContext;
import org.overlord.sramp.integration.artifacttypedetector.ArtifactTypeDetector;

public abstract class AbstractArtifactTypeDetector
implements ArtifactTypeDetector {
    @Override
    public boolean isArchive(ArtifactContent content) {
        String filename = content.getFilename();
        return filename.endsWith(".jar") || filename.endsWith(".ear") || filename.endsWith(".war") || filename.endsWith(".zip");
    }

    @Override
    public boolean allowExpansionFromArchive(ArtifactContent content, ArchiveContext archiveContext) {
        if (content.getFilename().endsWith(".xsd") || content.getFilename().endsWith(".wsdl") || content.getFilename().endsWith(".wspolicy") || content.getFilename().endsWith(".sha1") || content.getFilename().endsWith(".pom")) {
            return true;
        }
        return content.getFilename().endsWith(".xml") && !content.getFilename().equals("pom.xml");
    }
}

