/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.integration.artifacttypedetector;

import org.overlord.sramp.common.ArtifactContent;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.integration.ArchiveContext;
import org.overlord.sramp.integration.artifacttypedetector.AbstractArtifactTypeDetector;

public class DefaultArtifactTypeDetector
extends AbstractArtifactTypeDetector {
    @Override
    public ArtifactType detect(ArtifactContent content) {
        String filename = content.getFilename().toLowerCase();
        if (filename.endsWith(".xml")) {
            return ArtifactType.XmlDocument();
        }
        if (filename.endsWith(".wsdl")) {
            return ArtifactType.WsdlDocument();
        }
        if (filename.endsWith(".xsd")) {
            return ArtifactType.XsdDocument();
        }
        if (filename.endsWith(".wspolicy")) {
            return ArtifactType.PolicyDocument();
        }
        return ArtifactType.Document();
    }

    @Override
    public ArtifactType detect(ArtifactContent content, ArchiveContext archiveContext) {
        if (archiveContext.isExpandedFromArchive()) {
            return this.detect(content);
        }
        if (content.getFilename().endsWith(".zip")) {
            return ArtifactType.valueOf((String)"ZipArchive", (boolean)true);
        }
        return null;
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

