/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.karaf.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.felix.gogo.commands.Command;
import org.overlord.commons.codec.AesEncrypter;
import org.overlord.commons.karaf.commands.configure.AbstractConfigureCommand;
import org.overlord.sramp.karaf.commands.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(scope="overlord:s-ramp", name="configure")
public class ConfigureCommand
extends AbstractConfigureCommand {
    private static final Logger logger = LoggerFactory.getLogger(ConfigureCommand.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doExecute() throws Exception {
        logger.info(Messages.getString("configure.command.executed"));
        super.doExecute();
        logger.debug(Messages.getString("configure.command.copying.files"));
        this.copyFile("sramp-modeshape-fuse.json", "sramp-modeshape.json");
        this.copyFile("sramp-ui.properties");
        logger.debug(Messages.getString("configure.command.copying.files.end"));
        String randomSrampJmsPassword = UUID.randomUUID().toString();
        logger.debug(Messages.getString("configure.command.adding.jms.user"));
        Properties usersProperties = new Properties();
        File srcFile = new File(this.karafConfigPath + "users.properties");
        FileInputStream fis = new FileInputStream(srcFile);
        try {
            usersProperties.load(fis);
        }
        finally {
            IOUtils.closeQuietly((InputStream)fis);
        }
        String encryptedPassword = "{CRYPT}" + DigestUtils.sha256Hex((String)randomSrampJmsPassword) + "{CRYPT}";
        usersProperties.setProperty("srampjms", encryptedPassword);
        logger.debug(Messages.getString("configure.command.adding.user.end"));
        String adminUser = (String)usersProperties.get("admin");
        if (!adminUser.contains("admin.sramp")) {
            adminUser = adminUser + ",admin.sramp";
            usersProperties.setProperty("admin", adminUser);
        }
        logger.debug(Messages.getString("configure.command.modify.admin.roles"));
        FileOutputStream fos = new FileOutputStream(srcFile);
        try {
            usersProperties.store(fos, "");
        }
        finally {
            IOUtils.closeQuietly((OutputStream)fos);
        }
        logger.debug(Messages.getString("configure.command.modifying.sramp.properties"));
        Properties srampProperties = new Properties();
        InputStream is = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/sramp.properties");
        try {
            srampProperties.load(is);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        encryptedPassword = "${crypt:" + AesEncrypter.encrypt((String)randomSrampJmsPassword) + "}";
        srampProperties.setProperty("sramp.config.events.jms.user", "srampjms");
        srampProperties.setProperty("sramp.config.events.jms.password", encryptedPassword);
        File destFile = new File(this.karafConfigPath + "sramp.properties");
        fos = new FileOutputStream(destFile);
        try {
            srampProperties.store(fos, "");
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        String message = Messages.format("configure.command.new.user.added", "srampjms");
        logger.info(message);
        File dir = new File(this.karafConfigPath + "overlord-apps");
        if (!dir.exists()) {
            dir.mkdir();
        }
        this.copyFile("srampui-overlordapp.properties", "overlord-apps/srampui-overlordapp.properties");
        logger.info(Messages.getString("configure.command.end.execution"));
        return null;
    }
}

