/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedInput;
import org.jboss.resteasy.util.GenericType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.visitors.ArtifactContentTypeVisitor;
import org.overlord.sramp.atom.visitors.ArtifactToFullAtomEntryVisitor;
import org.overlord.sramp.common.ArtifactNotFoundException;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.ArtifactTypeEnum;
import org.overlord.sramp.common.InvalidArtifactCreationException;
import org.overlord.sramp.common.Sramp;
import org.overlord.sramp.common.SrampConstants;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.repository.PersistenceFactory;
import org.overlord.sramp.repository.PersistenceManager;
import org.overlord.sramp.repository.errors.DerivedArtifactCreateException;
import org.overlord.sramp.repository.errors.DerivedArtifactDeleteException;
import org.overlord.sramp.server.atom.services.AbstractResource;
import org.overlord.sramp.server.atom.services.ArtifactResource;
import org.overlord.sramp.server.atom.services.BatchResource;
import org.overlord.sramp.server.i18n.Messages;
import org.overlord.sramp.server.mime.MimeTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/s-ramp")
public class ArtifactResource
extends AbstractResource {
    private static Logger logger = LoggerFactory.getLogger(BatchResource.class);
    private static final ThreadLocal<SimpleDateFormat> dateFormat = new /* Unavailable Anonymous Inner Class!! */;
    private final Sramp sramp = new Sramp();

    @POST
    @Path(value="{model}/{type}")
    @Consumes(value={"application/atom+xml;type=entry"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@Context HttpServletRequest request, @PathParam(value="model") String model, @PathParam(value="type") String type, Entry entry) throws SrampAtomException {
        try {
            String baseUrl = this.sramp.getBaseUrl(request.getRequestURL().toString());
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)false);
            if (artifactType.isDerived()) {
                throw new DerivedArtifactCreateException(artifactType.getArtifactType());
            }
            BaseArtifactType artifact = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            if (SrampModelUtils.isDocumentArtifact((BaseArtifactType)artifact)) {
                throw new InvalidArtifactCreationException(Messages.i18n.format("INVALID_DOCARTY_CREATE", new Object[0]));
            }
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType persistedArtifact = persistenceManager.persistArtifact(artifact, null);
            ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)persistedArtifact);
            return visitor.getAtomEntry();
        }
        catch (Exception e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_ARTY", new Object[0]), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
    }

    @POST
    @Path(value="{model}/{type}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@Context HttpServletRequest request, @HeaderParam(value="Slug") String fileName, @PathParam(value="model") String model, @PathParam(value="type") String type, InputStream is) throws SrampAtomException {
        try {
            String baseUrl = this.sramp.getBaseUrl(request.getRequestURL().toString());
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)true);
            if (artifactType.isDerived()) {
                throw new DerivedArtifactCreateException(artifactType.getArtifactType());
            }
            is = ArtifactResource.ensureSupportsMark((InputStream)is);
            String mimeType = MimeTypes.determineMimeType((String)fileName, (InputStream)is, (ArtifactType)artifactType);
            artifactType.setMimeType(mimeType);
            if (fileName == null) {
                fileName = artifactType.getArtifactType() == ArtifactTypeEnum.Document ? "newartifact.bin" : (artifactType.getArtifactType() == ArtifactTypeEnum.XmlDocument ? "newartifact.xml" : "newartifact." + artifactType.getArtifactType().getModel());
            }
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType baseArtifactType = artifactType.newArtifactInstance();
            if (!SrampModelUtils.isDocumentArtifact((BaseArtifactType)baseArtifactType)) {
                throw new InvalidArtifactCreationException(Messages.i18n.format("INVALID_DOCARTY_CREATE", new Object[0]));
            }
            baseArtifactType.setName(fileName);
            BaseArtifactType artifact = persistenceManager.persistArtifact(baseArtifactType, is);
            ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            Entry entry = visitor.getAtomEntry();
            return entry;
        }
        catch (Exception e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_ARTY", new Object[0]), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @POST
    @Path(value="{model}/{type}")
    @Consumes(value={"multipart/related"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry createMultiPart(@Context HttpServletRequest request, @PathParam(value="model") String model, @PathParam(value="type") String type, MultipartRelatedInput input) throws SrampAtomException {
        Entry entry;
        InputStream contentStream = null;
        try {
            String baseUrl = this.sramp.getBaseUrl(request.getRequestURL().toString());
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)false);
            if (artifactType.isDerived()) {
                throw new DerivedArtifactCreateException(artifactType.getArtifactType());
            }
            List list = input.getParts();
            if (list.size() != 2) {
                throw new SrampAtomException(Messages.i18n.format("INVALID_MULTIPART_POST", new Object[]{list.size()}));
            }
            InputPart firstPart = (InputPart)list.get(0);
            InputPart secondpart = (InputPart)list.get(1);
            Entry atomEntry = (Entry)firstPart.getBody((GenericType)new /* Unavailable Anonymous Inner Class!! */);
            BaseArtifactType artifactMetaData = SrampAtomUtils.unwrapSrampArtifact((ArtifactType)artifactType, (Entry)atomEntry);
            ArtifactType metaDataType = ArtifactType.valueOf((BaseArtifactType)artifactMetaData);
            if (metaDataType.getArtifactType() != artifactType.getArtifactType()) {
                String errorMsg = Messages.i18n.format("INVALID_MULTIPART_POST_2", new Object[]{metaDataType.getArtifactType().getType(), artifactType.getArtifactType().getType()});
                throw new SrampAtomException(errorMsg);
            }
            String fileName = null;
            if (artifactMetaData.getName() != null) {
                fileName = artifactMetaData.getName();
            }
            contentStream = ArtifactResource.ensureSupportsMark((InputStream)((InputStream)secondpart.getBody((GenericType)new /* Unavailable Anonymous Inner Class!! */)));
            String mimeType = MimeTypes.determineMimeType((String)fileName, (InputStream)contentStream, (ArtifactType)artifactType);
            artifactType.setMimeType(mimeType);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType artifactRval = persistenceManager.persistArtifact(artifactMetaData, contentStream);
            ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifactRval);
            entry = visitor.getAtomEntry();
        }
        catch (Exception e) {
            try {
                ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_CREATING_ARTY", new Object[0]), (Throwable)e);
                throw new SrampAtomException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(contentStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)contentStream);
        return entry;
    }

    @PUT
    @Path(value="{model}/{type}/{uuid}")
    @Consumes(value={"application/atom+xml;type=entry"})
    public void updateMetaData(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid, Entry atomEntry) throws SrampAtomException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, null);
            if (artifactType.isExtendedType()) {
                artifactType = SrampAtomUtils.getArtifactType((Entry)atomEntry);
            }
            BaseArtifactType artifact = SrampAtomUtils.unwrapSrampArtifact((ArtifactType)artifactType, (Entry)atomEntry);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            persistenceManager.updateArtifact(artifact, artifactType);
        }
        catch (Throwable e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_UPDATING_META_DATA", new Object[]{uuid}), (Throwable)e);
            throw new SrampAtomException(e);
        }
    }

    @PUT
    @Path(value="{model}/{type}/{uuid}/media")
    public void updateContent(@HeaderParam(value="Slug") String fileName, @PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid, InputStream content) throws SrampAtomException {
        InputStream is = ArtifactResource.ensureSupportsMark((InputStream)content);
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)true);
            if (artifactType.isDerived()) {
                throw new DerivedArtifactCreateException(artifactType.getArtifactType());
            }
            String mimeType = MimeTypes.determineMimeType((String)fileName, (InputStream)is, (ArtifactType)artifactType);
            artifactType.setMimeType(mimeType);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            persistenceManager.updateArtifactContent(uuid, artifactType, is);
        }
        catch (Exception e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_UPDATING_CONTENT", new Object[]{uuid}), (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @GET
    @Path(value="{model}/{type}/{uuid}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry getMetaData(@Context HttpServletRequest request, @PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws SrampAtomException {
        try {
            String baseUrl = this.sramp.getBaseUrl(request.getRequestURL().toString());
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)false);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType artifact = persistenceManager.getArtifact(uuid, artifactType);
            if (artifact == null) {
                throw new ArtifactNotFoundException(uuid);
            }
            ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            return visitor.getAtomEntry();
        }
        catch (Throwable e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_GETTING_META_DATA", new Object[]{uuid}), (Throwable)e);
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Path(value="{model}/{type}/{uuid}/media")
    public Response getContent(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws SrampAtomException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, (Boolean)true);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType baseArtifact = persistenceManager.getArtifact(uuid, artifactType);
            if (baseArtifact == null) {
                throw new ArtifactNotFoundException(uuid);
            }
            ArtifactContentTypeVisitor ctVizzy = new ArtifactContentTypeVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)ctVizzy, (BaseArtifactType)baseArtifact);
            MediaType mediaType = ctVizzy.getContentType();
            artifactType.setMimeType(mediaType.toString());
            InputStream artifactContent = persistenceManager.getArtifactContent(uuid, artifactType);
            4 output = new /* Unavailable Anonymous Inner Class!! */;
            String lastModifiedDate = ((SimpleDateFormat)dateFormat.get()).format(baseArtifact.getLastModifiedTimestamp().toGregorianCalendar().getTime());
            return Response.ok((Object)output, (String)artifactType.getMimeType()).header("Content-Disposition", (Object)("attachment; filename=" + baseArtifact.getName())).header("Content-Length", baseArtifact.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)).header("Last-Modified", (Object)lastModifiedDate).build();
        }
        catch (Throwable e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_GETTING_CONTENT", new Object[]{uuid}), (Throwable)e);
            throw new SrampAtomException(e);
        }
    }

    @DELETE
    @Path(value="{model}/{type}/{uuid}")
    public void delete(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws SrampAtomException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type, null);
            if (artifactType.isDerived()) {
                throw new DerivedArtifactDeleteException(artifactType.getArtifactType());
            }
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            persistenceManager.deleteArtifact(uuid, artifactType);
        }
        catch (Throwable e) {
            ArtifactResource.logError((Logger)logger, (String)Messages.i18n.format("ERROR_DELETING_ARTY", new Object[]{uuid}), (Throwable)e);
            throw new SrampAtomException(e);
        }
    }
}

