/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedInput;
import org.jboss.resteasy.util.GenericType;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.visitors.ArtifactContentTypeVisitor;
import org.overlord.sramp.atom.visitors.ArtifactToFullAtomEntryVisitor;
import org.overlord.sramp.common.ArtifactNotFoundException;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.ArtifactTypeEnum;
import org.overlord.sramp.common.MimeTypes;
import org.overlord.sramp.common.Sramp;
import org.overlord.sramp.common.SrampConstants;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.repository.PersistenceFactory;
import org.overlord.sramp.repository.PersistenceManager;
import org.overlord.sramp.server.atom.services.AbstractResource;
import org.overlord.sramp.server.atom.services.BatchResource;
import org.overlord.sramp.server.atom.services.errors.DerivedArtifactAccessException;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/s-ramp")
public class ArtifactResource
extends AbstractResource {
    private static Logger logger = LoggerFactory.getLogger(BatchResource.class);
    private static final ThreadLocal<SimpleDateFormat> dateFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
        }
    };
    private final Sramp sramp = new Sramp();

    @POST
    @Path(value="{model}/{type}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@Context HttpServletRequest request, @HeaderParam(value="Content-Type") String contentType, @HeaderParam(value="Slug") String fileName, @PathParam(value="model") String model, @PathParam(value="type") String type, InputStream is) throws SrampAtomException {
        try {
            String baseUrl = this.sramp.getBaseUrl(request.getRequestURL().toString());
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type);
            if (artifactType.getArtifactType().isDerived()) {
                throw new DerivedArtifactAccessException(artifactType.getArtifactType());
            }
            String mimeType = MimeTypes.determineMimeType((String)contentType, (String)fileName, (ArtifactType)artifactType);
            artifactType.setMimeType(mimeType);
            if (fileName == null) {
                fileName = artifactType.getArtifactType() == ArtifactTypeEnum.Document ? "newartifact.bin" : (artifactType.getArtifactType() == ArtifactTypeEnum.XmlDocument ? "newartifact.xml" : "newartifact." + artifactType.getArtifactType().getModel());
            }
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType baseArtifactType = artifactType.newArtifactInstance();
            baseArtifactType.setName(fileName);
            BaseArtifactType artifact = persistenceManager.persistArtifact(baseArtifactType, is);
            ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            Entry entry = visitor.getAtomEntry();
            return entry;
        }
        catch (Exception e) {
            ArtifactResource.logError(logger, "Error creating an artifact.", e);
            throw new SrampAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @POST
    @Path(value="{model}/{type}")
    @Consumes(value={"multipart/related"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry createMultiPart(@Context HttpServletRequest request, @HeaderParam(value="Content-Type") String contentType, @PathParam(value="model") String model, @PathParam(value="type") String type, MultipartRelatedInput input) throws SrampAtomException {
        Entry entry;
        InputStream contentStream = null;
        try {
            String baseUrl = this.sramp.getBaseUrl(request.getRequestURL().toString());
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type);
            if (artifactType.getArtifactType().isDerived()) {
                throw new DerivedArtifactAccessException(artifactType.getArtifactType());
            }
            List list = input.getParts();
            if (list.size() != 2) {
                throw new SrampAtomException("Invalid multi-part POST - expected two parts but got " + list.size());
            }
            InputPart firstPart = (InputPart)list.get(0);
            InputPart secondpart = (InputPart)list.get(1);
            Entry atomEntry = (Entry)firstPart.getBody((GenericType)new GenericType<Entry>(){});
            BaseArtifactType artifactMetaData = SrampAtomUtils.unwrapSrampArtifact((ArtifactType)artifactType, (Entry)atomEntry);
            ArtifactType metaDataType = ArtifactType.valueOf((BaseArtifactType)artifactMetaData);
            if (metaDataType.getArtifactType() != artifactType.getArtifactType()) {
                String errorMsg = String.format("Invalid multi-part POST - attempted to POST a '%1$s' to the '%2$s' endpoint.", metaDataType.getArtifactType().getType(), artifactType.getArtifactType().getType());
                throw new SrampAtomException(errorMsg);
            }
            String fileName = null;
            if (artifactMetaData.getName() != null) {
                fileName = artifactMetaData.getName();
            }
            String mimeType = MimeTypes.determineMimeType((String)contentType, (String)fileName, (ArtifactType)artifactType);
            artifactType.setMimeType(mimeType);
            contentStream = (InputStream)secondpart.getBody((GenericType)new GenericType<InputStream>(){});
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType artifactRval = persistenceManager.persistArtifact(artifactMetaData, contentStream);
            ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifactRval);
            entry = visitor.getAtomEntry();
        }
        catch (Exception e) {
            try {
                ArtifactResource.logError(logger, "Error creating an artifact.", e);
                throw new SrampAtomException((Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(contentStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)contentStream);
        return entry;
    }

    @PUT
    @Path(value="{model}/{type}/{uuid}")
    @Consumes(value={"application/atom+xml;type=entry"})
    public void updateMetaData(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid, Entry atomEntry) throws SrampAtomException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type);
            BaseArtifactType artifact = SrampAtomUtils.unwrapSrampArtifact((ArtifactType)artifactType, (Entry)atomEntry);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            persistenceManager.updateArtifact(artifact, artifactType);
        }
        catch (Throwable e) {
            ArtifactResource.logError(logger, "Error updating artifact meta data for: " + uuid, e);
            throw new SrampAtomException(e);
        }
    }

    @PUT
    @Path(value="{model}/{type}/{uuid}/media")
    public void updateContent(@HeaderParam(value="Content-Type") String contentType, @HeaderParam(value="Slug") String fileName, @PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid, InputStream content) throws SrampAtomException {
        InputStream is = content;
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type);
            if (artifactType.getArtifactType().isDerived()) {
                throw new DerivedArtifactAccessException(artifactType.getArtifactType());
            }
            String mimeType = MimeTypes.determineMimeType((String)contentType, (String)fileName, (ArtifactType)artifactType);
            artifactType.setMimeType(mimeType);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            persistenceManager.updateArtifactContent(uuid, artifactType, is);
        }
        catch (Exception e) {
            ArtifactResource.logError(logger, "Error updating artifact content for: " + uuid, e);
            throw new SrampAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    @GET
    @Path(value="{model}/{type}/{uuid}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry getMetaData(@Context HttpServletRequest request, @PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws SrampAtomException {
        try {
            String baseUrl = this.sramp.getBaseUrl(request.getRequestURL().toString());
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType artifact = persistenceManager.getArtifact(uuid, artifactType);
            if (artifact == null) {
                throw new ArtifactNotFoundException(uuid);
            }
            ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
            return visitor.getAtomEntry();
        }
        catch (Throwable e) {
            ArtifactResource.logError(logger, "Error getting artifact meta data for: " + uuid, e);
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Path(value="{model}/{type}/{uuid}/media")
    public Response getContent(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws SrampAtomException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            BaseArtifactType baseArtifact = persistenceManager.getArtifact(uuid, artifactType);
            ArtifactContentTypeVisitor ctVizzy = new ArtifactContentTypeVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)ctVizzy, (BaseArtifactType)baseArtifact);
            MediaType mediaType = ctVizzy.getContentType();
            artifactType.setMimeType(mediaType.toString());
            final InputStream artifactContent = persistenceManager.getArtifactContent(uuid, artifactType);
            StreamingOutput output = new StreamingOutput(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void write(OutputStream output) throws IOException, WebApplicationException {
                    try {
                        IOUtils.copy((InputStream)artifactContent, (OutputStream)output);
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)artifactContent);
                    }
                }
            };
            String lastModifiedDate = dateFormat.get().format(baseArtifact.getLastModifiedTimestamp().toGregorianCalendar().getTime());
            return Response.ok((Object)output, (String)artifactType.getMimeType()).header("Content-Disposition", (Object)("attachment; filename=" + baseArtifact.getName())).header("Content-Length", baseArtifact.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)).header("Last-Modified", (Object)lastModifiedDate).build();
        }
        catch (Throwable e) {
            ArtifactResource.logError(logger, "Error getting artifact content for: " + uuid, e);
            throw new SrampAtomException(e);
        }
    }

    @DELETE
    @Path(value="{model}/{type}/{uuid}")
    public void delete(@PathParam(value="model") String model, @PathParam(value="type") String type, @PathParam(value="uuid") String uuid) throws SrampAtomException {
        try {
            ArtifactType artifactType = ArtifactType.valueOf((String)model, (String)type);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            persistenceManager.deleteArtifact(uuid, artifactType);
        }
        catch (Throwable e) {
            ArtifactResource.logError(logger, "Error deleting artifact: " + uuid, e);
            throw new SrampAtomException(e);
        }
    }
}

