/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.jboss.resteasy.util.GenericType;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.common.Sramp;
import org.overlord.sramp.server.atom.services.AbstractFeedResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/s-ramp")
public class QueryResource
extends AbstractFeedResource {
    private static Logger logger = LoggerFactory.getLogger(QueryResource.class);
    private final Sramp sramp = new Sramp();

    @GET
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed queryFromGet(@Context HttpServletRequest request, @QueryParam(value="query") String query, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="startIndex") Integer startIndex, @QueryParam(value="count") Integer count, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="ascending") Boolean asc, @QueryParam(value="propertyName") Set<String> propNames) throws SrampAtomException {
        try {
            String baseUrl = this.sramp.getBaseUrl(request.getRequestURL().toString());
            if (startIndex == null && startPage != null) {
                int c = count != null ? count : 100;
                startIndex = (startPage - 1) * c;
            }
            return this.query(query, startIndex, count, orderBy, asc, propNames, baseUrl);
        }
        catch (Throwable e) {
            QueryResource.logError(logger, "Error executing S-RAMP query: " + query, e);
            throw new SrampAtomException(e);
        }
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed queryFromPost(@Context HttpServletRequest request, MultipartFormDataInput input) throws SrampAtomException {
        String query = null;
        try {
            String baseUrl = this.sramp.getBaseUrl(request.getRequestURL().toString());
            query = (String)input.getFormDataPart("query", (GenericType)new GenericType<String>(){});
            Integer startPage = (Integer)input.getFormDataPart("startPage", (GenericType)new GenericType<Integer>(){});
            Integer startIndex = (Integer)input.getFormDataPart("startIndex", (GenericType)new GenericType<Integer>(){});
            Integer count = (Integer)input.getFormDataPart("count", (GenericType)new GenericType<Integer>(){});
            String orderBy = (String)input.getFormDataPart("orderBy", (GenericType)new GenericType<String>(){});
            Boolean asc = (Boolean)input.getFormDataPart("ascending", (GenericType)new GenericType<Boolean>(){});
            HashSet<String> propNames = new HashSet<String>();
            List list = (List)input.getFormDataMap().get("propertyName");
            if (list != null) {
                for (InputPart inputPart : list) {
                    propNames.add(inputPart.getBodyAsString());
                }
            }
            if (startIndex == null && startPage != null) {
                int c = count != null ? count : 100;
                startIndex = (startPage - 1) * c;
            }
            return this.query(query, startIndex, count, orderBy, asc, propNames, baseUrl);
        }
        catch (SrampAtomException e) {
            throw e;
        }
        catch (Throwable e) {
            QueryResource.logError(logger, "Error executing S-RAMP query: " + query, e);
            throw new SrampAtomException(e);
        }
    }

    protected Feed query(String query, Integer startIndex, Integer count, String orderBy, Boolean ascending, Set<String> propNames, String baseUrl) throws SrampAtomException {
        if (query == null) {
            throw new SrampAtomException("Missing S-RAMP query (param with name 'query').");
        }
        String xpath = query;
        if (!xpath.startsWith("/s-ramp")) {
            xpath = query.startsWith("/") ? "/s-ramp" + query : "/s-ramp/" + query;
        }
        return this.createArtifactFeed(xpath, startIndex, count, orderBy, ascending, propNames, baseUrl);
    }
}

