/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.mappers;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.overlord.sramp.common.ontology.SrampOntology;
import org.w3._1999._02._22_rdf_syntax_ns_.RDF;
import org.w3._2002._07.owl_.Class;
import org.w3._2002._07.owl_.Ontology;

public class RdfToOntologyMapper {
    public void map(RDF rdf, SrampOntology ontology) throws Exception {
        SrampOntology.Class oclass;
        Ontology rdfOntology = rdf.getOntology();
        String base = (String)rdf.getOtherAttributes().get(new QName("http://www.w3.org/XML/1998/namespace", "base"));
        ontology.setBase(base);
        ontology.setId(rdfOntology.getID());
        ontology.setLabel(rdfOntology.getLabel());
        ontology.setComment(rdfOntology.getComment());
        ArrayList<Object[]> classes = new ArrayList<Object[]>();
        HashMap<String, SrampOntology.Class> idIndex = new HashMap<String, SrampOntology.Class>();
        HashMap<String, SrampOntology.Class> uriIndex = new HashMap<String, SrampOntology.Class>();
        for (Class rdfClass : rdf.getClazz()) {
            oclass = new SrampOntology.Class();
            oclass.setId(rdfClass.getID());
            oclass.setLabel(rdfClass.getLabel());
            oclass.setComment(rdfClass.getComment());
            String uri = base + "#" + rdfClass.getID();
            oclass.setUri(new URI(uri));
            Object[] classData = new Object[]{oclass, rdfClass.getSubClassOf() != null ? rdfClass.getSubClassOf().getResource() : null};
            classes.add(classData);
            idIndex.put(rdfClass.getID(), oclass);
            uriIndex.put(uri, oclass);
        }
        for (Object[] classData : classes) {
            oclass = (SrampOntology.Class)classData[0];
            String resourceRef = (String)classData[1];
            if (resourceRef == null) {
                ontology.getRootClasses().add(oclass);
                continue;
            }
            SrampOntology.Class parent = (SrampOntology.Class)idIndex.get(resourceRef);
            if (parent == null) {
                parent = (SrampOntology.Class)uriIndex.get(resourceRef);
            }
            if (parent == null) {
                throw new Exception("Failed to resolve parent class reference: " + resourceRef);
            }
            parent.getChildren().add(oclass);
            oclass.setParent(parent);
        }
    }
}

