/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services;

import java.io.InputStream;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.annotations.providers.multipart.PartType;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.multipart.MultipartOutput;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.atom.beans.HttpResponseBean;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.visitors.ArtifactContentTypeVisitor;
import org.overlord.sramp.atom.visitors.ArtifactToFullAtomEntryVisitor;
import org.overlord.sramp.common.ArtifactNotFoundException;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.Sramp;
import org.overlord.sramp.common.SrampServerException;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.repository.PersistenceFactory;
import org.overlord.sramp.repository.PersistenceManager;
import org.overlord.sramp.server.atom.services.AbstractResource;
import org.overlord.sramp.server.atom.services.errors.DerivedArtifactAccessException;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/s-ramp")
public class BatchResource
extends AbstractResource {
    private static Logger logger = LoggerFactory.getLogger(BatchResource.class);
    private final Sramp sramp = new Sramp();

    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"multipart/mixed"})
    @PartType(value="message/http")
    public MultipartOutput zipPackage(@Context HttpServletRequest request, @HeaderParam(value="Slug") String fileName, InputStream content) throws SrampAtomException {
        InputStream is = content;
        SrampArchive archive = null;
        String baseUrl = this.sramp.getBaseUrl(request.getRequestURL().toString());
        try {
            archive = new SrampArchive(content);
            MultipartOutput output = new MultipartOutput();
            output.setBoundary("package");
            Collection entries = archive.getEntries();
            for (SrampArchiveEntry entry : entries) {
                BaseArtifactType metaData = entry.getMetaData();
                InputStream contentStream = archive.getInputStream(entry);
                this.processBatchEntry(output, entry.getPath(), metaData, contentStream, baseUrl);
            }
            MultipartOutput multipartOutput = output;
            return multipartOutput;
        }
        catch (Exception e) {
            BatchResource.logError((Logger)logger, (String)"Error consuming S-RAMP batch zip package.", (Throwable)e);
            throw new SrampAtomException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
            if (archive != null) {
                SrampArchive.closeQuietly((SrampArchive)archive);
            }
        }
    }

    private void processBatchEntry(MultipartOutput output, String path, BaseArtifactType metaData, InputStream contentStream, String baseUrl) {
        block6: {
            String contentId = String.format("<%1$s@package>", path);
            try {
                ArtifactType artifactType = ArtifactType.valueOf((BaseArtifactType)metaData);
                if (artifactType.getArtifactType().isDerived()) {
                    throw new DerivedArtifactAccessException(artifactType.getArtifactType());
                }
                ArtifactContentTypeVisitor ctVizzy = new ArtifactContentTypeVisitor();
                ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)ctVizzy, (BaseArtifactType)metaData);
                String mimeType = ctVizzy.getContentType().toString();
                artifactType.setMimeType(mimeType);
                if (metaData.getUuid() == null && contentStream != null) {
                    Entry atomEntry = this.processCreate(artifactType, metaData, contentStream, baseUrl);
                    this.addCreatedPart(output, contentId, atomEntry);
                    break block6;
                }
                if (metaData.getUuid() != null && contentStream != null) {
                    Entry atomEntry = this.processUpdateOrCreate(artifactType, metaData, contentStream, baseUrl);
                    this.addCreatedPart(output, contentId, atomEntry);
                    break block6;
                }
                if (metaData.getUuid() != null && contentStream == null) {
                    Entry atomEntry = this.processUpdate(artifactType, metaData, baseUrl);
                    this.addCreatedPart(output, contentId, atomEntry);
                    break block6;
                }
                throw new SrampServerException("Unsupported path (TBD).");
            }
            catch (Exception e) {
                HttpResponseBean errorResponse = new HttpResponseBean(409, "Conflict");
                SrampAtomException error = new SrampAtomException((Throwable)e);
                errorResponse.setBody((Object)error, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_SRAMP_ATOM_EXCEPTION_TYPE);
                output.addPart((Object)errorResponse, (javax.ws.rs.core.MediaType)MediaType.MESSAGE_HTTP_TYPE).getHeaders().putSingle((Object)"Content-ID", (Object)contentId);
            }
        }
    }

    private Entry processCreate(ArtifactType artifactType, BaseArtifactType metaData, InputStream contentStream, String baseUrl) throws Exception {
        PersistenceManager persistenceManager = PersistenceFactory.newInstance();
        BaseArtifactType artifact = persistenceManager.persistArtifact(metaData, contentStream);
        artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
        ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
        Entry atomEntry = visitor.getAtomEntry();
        return atomEntry;
    }

    private Entry processUpdateOrCreate(ArtifactType artifactType, BaseArtifactType metaData, InputStream contentStream, String baseUrl) throws Exception {
        PersistenceManager persistenceManager = PersistenceFactory.newInstance();
        BaseArtifactType artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
        if (artifact == null) {
            return this.processCreate(artifactType, metaData, contentStream, baseUrl);
        }
        persistenceManager.updateArtifact(metaData, artifactType);
        persistenceManager.updateArtifactContent(metaData.getUuid(), artifactType, contentStream);
        artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
        ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
        Entry atomEntry = visitor.getAtomEntry();
        return atomEntry;
    }

    private Entry processUpdate(ArtifactType artifactType, BaseArtifactType metaData, String baseUrl) throws Exception {
        PersistenceManager persistenceManager = PersistenceFactory.newInstance();
        BaseArtifactType artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
        if (artifact == null) {
            throw new ArtifactNotFoundException(metaData.getUuid());
        }
        persistenceManager.updateArtifact(metaData, artifactType);
        artifact = persistenceManager.getArtifact(metaData.getUuid(), artifactType);
        ArtifactToFullAtomEntryVisitor visitor = new ArtifactToFullAtomEntryVisitor(baseUrl);
        ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)artifact);
        Entry atomEntry = visitor.getAtomEntry();
        return atomEntry;
    }

    private void addCreatedPart(MultipartOutput output, String contentId, Entry atomEntry) {
        HttpResponseBean createdResponse = new HttpResponseBean(201, "Created");
        createdResponse.setBody((Object)atomEntry, (javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_ENTRY_TYPE);
        output.addPart((Object)createdResponse, (javax.ws.rs.core.MediaType)MediaType.MESSAGE_HTTP_TYPE).getHeaders().putSingle((Object)"Content-ID", (Object)contentId);
    }
}

