/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedOutput;
import org.jboss.resteasy.test.TestPortProvider;
import org.junit.Assert;
import org.junit.Test;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.client.ClientRequest;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.providers.SrampAtomExceptionProvider;
import org.overlord.sramp.common.SrampConstants;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.server.atom.services.AbstractResourceTest;
import org.s_ramp.xmlns._2010.s_ramp.Artifact;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactEnum;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.Document;
import org.s_ramp.xmlns._2010.s_ramp.DocumentArtifactEnum;
import org.s_ramp.xmlns._2010.s_ramp.DocumentArtifactTarget;
import org.s_ramp.xmlns._2010.s_ramp.ExtendedArtifactType;
import org.s_ramp.xmlns._2010.s_ramp.Message;
import org.s_ramp.xmlns._2010.s_ramp.PartEnum;
import org.s_ramp.xmlns._2010.s_ramp.PartTarget;
import org.s_ramp.xmlns._2010.s_ramp.WsdlDocument;
import org.s_ramp.xmlns._2010.s_ramp.XmlDocument;
import org.s_ramp.xmlns._2010.s_ramp.XsdDocument;
import test.org.overlord.sramp.server.TestUtils;

public class ArtifactResourceTest
extends AbstractResourceTest {
    String uuid = null;

    @Test
    public void testDerivedArtifactCreate() throws Exception {
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/xsd/ElementDeclaration"));
        String artifactFileName = "PO.xsd";
        InputStream POXsd = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        String xmltext = TestUtils.convertStreamToString(POXsd);
        POXsd.close();
        request.header("Slug", (Object)artifactFileName);
        request.body("application/xml", (Object)xmltext);
        try {
            request.post(String.class);
            Assert.fail((String)"Expected an error here.");
        }
        catch (SrampAtomException e) {
            Assert.assertEquals((Object)"Failed to create artifact because 'ElementDeclaration' is a derived type.", (Object)e.getMessage());
            String stack = SrampAtomExceptionProvider.getRootStackTrace((Throwable)e);
            Assert.assertTrue((boolean)stack.contains("org.overlord.sramp.server.atom.services.ArtifactResource.create"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPDFDocument() throws Exception {
        Document doc;
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "sample.pdf";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        try {
            request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/core/Document"));
            request.header("Slug", (Object)artifactFileName);
            request.body("application/pdf", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof Document));
            doc = (Document)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)218882L, (Object)doc.getContentSize());
            Assert.assertEquals((Object)"application/pdf", (Object)doc.getContentType());
            this.uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/core/Document/" + this.uuid)));
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertTrue((boolean)(arty instanceof Document));
        doc = (Document)arty;
        Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
        Assert.assertEquals((Object)218882L, (Object)doc.getContentSize());
        Assert.assertEquals((Object)"sample.pdf", (Object)doc.getName());
        Assert.assertEquals((Object)"application/pdf", (Object)doc.getContentType());
        ClientRequest request2 = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/core/Document/" + this.uuid + "/media")));
        ClientResponse response2 = request2.get(InputStream.class);
        if (response2.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        InputStream in = (InputStream)response2.getEntity();
        File file = new File("target/SRAMP-sample.pdf");
        FileOutputStream out = new FileOutputStream(file);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        out.flush();
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBrmsPkgDocument() throws Exception {
        ExtendedArtifactType doc;
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "defaultPackage.pkg";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/ext/" + artifactFileName);
        String uuid = null;
        try {
            request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/ext/BrmsPkgDocument"));
            request.header("Slug", (Object)artifactFileName);
            request.body("application/octet-stream", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof ExtendedArtifactType));
            doc = (ExtendedArtifactType)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)"BrmsPkgDocument", (Object)doc.getExtendedType());
            Assert.assertEquals((Object)17043L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)));
            Assert.assertEquals((Object)"application/octet-stream", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
            uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/ext/BrmsPkgDocument/" + uuid)));
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertTrue((boolean)(arty instanceof ExtendedArtifactType));
        doc = (ExtendedArtifactType)arty;
        Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
        Assert.assertEquals((Object)17043L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)));
        Assert.assertEquals((Object)"defaultPackage.pkg", (Object)doc.getName());
        Assert.assertEquals((Object)"application/octet-stream", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJPGDocument() throws Exception {
        ExtendedArtifactType doc;
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "photo.jpg";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/ext/" + artifactFileName);
        String uuid = null;
        try {
            request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/ext/JpgDocument"));
            request.header("Slug", (Object)artifactFileName);
            request.body("application/octet-stream", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof ExtendedArtifactType));
            doc = (ExtendedArtifactType)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)"JpgDocument", (Object)doc.getExtendedType());
            Assert.assertEquals((Object)2398L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)));
            Assert.assertEquals((Object)"application/octet-stream", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
            uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/ext/JpgDocument/" + uuid)));
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertTrue((boolean)(arty instanceof ExtendedArtifactType));
        doc = (ExtendedArtifactType)arty;
        Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
        Assert.assertEquals((Object)2398L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)));
        Assert.assertEquals((Object)"photo.jpg", (Object)doc.getName());
        Assert.assertEquals((Object)"application/octet-stream", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
        ClientRequest request2 = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/ext/JpgDocument/" + uuid + "/media")));
        ClientResponse response2 = request2.get(InputStream.class);
        if (response2.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        InputStream in = (InputStream)response2.getEntity();
        File file = new File("target/SRAMP-photo.jpg");
        FileOutputStream out = new FileOutputStream(file);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        out.flush();
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBpmnExtendedDocumentCreate() throws Exception {
        ExtendedArtifactType doc;
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "Evaluation.bpmn";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/ext/" + artifactFileName);
        String uuid = null;
        try {
            request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/ext/BpmnDocument"));
            request.header("Slug", (Object)artifactFileName);
            request.body("application/xml", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof ExtendedArtifactType));
            doc = (ExtendedArtifactType)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)"BpmnDocument", (Object)doc.getExtendedType());
            Assert.assertEquals((Object)12482L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)));
            Assert.assertEquals((Object)"application/xml", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
            uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/ext/BpmnDocument/" + uuid)));
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertTrue((boolean)(arty instanceof ExtendedArtifactType));
        doc = (ExtendedArtifactType)arty;
        Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
        Assert.assertEquals((Object)12482L, (Object)Long.valueOf((String)doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_SIZE_QNAME)));
        Assert.assertEquals((Object)"Evaluation.bpmn", (Object)doc.getName());
        Assert.assertEquals((Object)"application/xml", doc.getOtherAttributes().get(SrampConstants.SRAMP_CONTENT_TYPE_QNAME));
        ClientResponse content = request.get(String.class);
        System.out.println("Content=" + (String)content.getEntity());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWsdlDocumentCreate() throws Exception {
        BaseArtifactType arty;
        Entry entry;
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "sample.wsdl";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/wsdl/" + artifactFileName);
        String uuid = null;
        try {
            request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/wsdl/WsdlDocument"));
            request.header("Slug", (Object)artifactFileName);
            request.body("application/xml", (Object)contentStream);
            response = request.post(Entry.class);
            entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof WsdlDocument));
            WsdlDocument doc = (WsdlDocument)arty;
            Assert.assertEquals((Object)artifactFileName, (Object)doc.getName());
            Assert.assertEquals((Object)1642L, (Object)doc.getContentSize());
            Assert.assertEquals((Object)"application/xml", (Object)doc.getContentType());
            uuid = doc.getUuid();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/wsdl/WsdlDocument/" + uuid)));
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertNotNull((Object)arty);
        Assert.assertTrue((boolean)(arty instanceof WsdlDocument));
        WsdlDocument wsdlDoc = (WsdlDocument)arty;
        Assert.assertEquals((Object)1642L, (Object)wsdlDoc.getContentSize());
        Assert.assertEquals((Object)"sample.wsdl", (Object)wsdlDoc.getName());
        ClientRequest frequest = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/wsdl/Message"));
        ClientResponse fresponse = frequest.get(Feed.class);
        Feed feed = (Feed)fresponse.getEntity();
        Assert.assertNotNull((Object)feed);
        Assert.assertEquals((long)2L, (long)feed.getEntries().size());
        String findReqMsgUuid = null;
        for (Entry atomEntry : feed.getEntries()) {
            if (!"findRequest".equals(atomEntry.getTitle())) continue;
            findReqMsgUuid = atomEntry.getId().toString();
        }
        Assert.assertNotNull(findReqMsgUuid);
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/wsdl/Message/" + findReqMsgUuid)));
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        Assert.assertNotNull((Object)arty);
        Assert.assertTrue((boolean)(arty instanceof Message));
        Message message = (Message)arty;
        Assert.assertEquals((Object)"findRequest", (Object)message.getNCName());
        Assert.assertEquals((Object)"http://ewittman.redhat.com/sample/2012/09/wsdl/sample.wsdl", (Object)message.getNamespace());
        DocumentArtifactTarget relatedDocumentTarget = message.getRelatedDocument();
        Assert.assertEquals((Object)DocumentArtifactEnum.WSDL_DOCUMENT, (Object)relatedDocumentTarget.getArtifactType());
        Assert.assertEquals((Object)uuid, (Object)relatedDocumentTarget.getValue());
        List parts = message.getPart();
        Assert.assertNotNull((Object)parts);
        Assert.assertEquals((long)1L, (long)parts.size());
        Assert.assertEquals((Object)PartEnum.PART, (Object)((PartTarget)parts.get(0)).getArtifactType());
        Assert.assertNotNull((Object)((PartTarget)parts.get(0)).getValue());
    }

    @Test
    public void testMultiPartCreate() {
        try {
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/core/XmlDocument"));
            MultipartRelatedOutput output = new MultipartRelatedOutput();
            XmlDocument xmlDocument = new XmlDocument();
            xmlDocument.setArtifactType(BaseArtifactEnum.XML_DOCUMENT);
            xmlDocument.setCreatedBy("kurt");
            xmlDocument.setDescription("In depth description of this XML document");
            xmlDocument.setName("PO.xml");
            xmlDocument.setUuid("my-uuid");
            xmlDocument.setVersion("1.0");
            Entry atomEntry = new Entry();
            Artifact arty = new Artifact();
            arty.setXmlDocument(xmlDocument);
            atomEntry.setAnyOtherJAXBObject((Object)arty);
            MediaType mediaType = new MediaType("application", "atom+xml");
            output.addPart((Object)atomEntry, (javax.ws.rs.core.MediaType)mediaType);
            String artifactFileName = "PO.xml";
            InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
            MediaType mediaType2 = new MediaType("application", "xml");
            output.addPart((Object)contentStream, (javax.ws.rs.core.MediaType)mediaType2);
            request.body("multipart/related", (Object)output);
            ClientResponse response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            Artifact artifact = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
            Assert.assertEquals((Object)"my-uuid", (Object)artifact.getXmlDocument().getUuid());
            Assert.assertEquals((Object)825L, (Object)artifact.getXmlDocument().getContentSize());
            Assert.assertEquals((Object)artifactFileName, (Object)artifact.getXmlDocument().getName());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateNoSlug() throws Exception {
        String artifactFileName = "sample.wsdl";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/wsdl/" + artifactFileName);
        try {
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/wsdl/WsdlDocument"));
            request.body("application/xml", (Object)contentStream);
            ClientResponse response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)"newartifact.wsdl", (Object)entry.getTitle());
            BaseArtifactType arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof WsdlDocument));
            WsdlDocument doc = (WsdlDocument)arty;
            Assert.assertEquals((Object)"newartifact.wsdl", (Object)doc.getName());
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testArtifactDerivation() throws Exception {
        ClientResponse response;
        ClientRequest request;
        String artifactFileName = "PO.xsd";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/xsd/XsdDocument"));
            request.body("application/xml", (Object)contentStream);
            response = request.post(Entry.class);
            response.getEntity();
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
        request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/xsd/ElementDeclaration"));
        response = request.get(Feed.class);
        Feed feed = (Feed)response.getEntity();
        Assert.assertEquals((long)2L, (long)feed.getEntries().size());
        HashMap<String, Entry> entryMap = new HashMap<String, Entry>();
        for (Entry entry : feed.getEntries()) {
            entryMap.put(entry.getTitle(), entry);
        }
        Entry purchaseOrder = (Entry)entryMap.get("purchaseOrder");
        Assert.assertNotNull((Object)purchaseOrder);
        Entry comment = (Entry)entryMap.get("comment");
        Assert.assertNotNull((Object)comment);
    }

    @Test
    public void testFullPurchaseOrderXSD() throws Exception {
        Entry entry = this.doAddXsd();
        URI entryId = entry.getId();
        entry = this.doGetXsdEntry(entryId);
        String content = this.doGetXsdContent(entryId);
        this.verifyXsdContent(content);
        this.doUpdateXsdEntry(entry);
        entry = this.doGetXsdEntry(entryId);
        this.verifyEntryUpdated(entry);
        this.doUpdateXsdContent(entry);
        content = this.doGetXsdContent(entryId);
        this.verifyContentUpdated(content);
        this.deleteXsdEntry(entryId);
        this.verifyEntryDeleted(entryId);
    }

    private Entry doAddXsd() throws Exception {
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/xsd/XsdDocument"));
        String artifactFileName = "PO.xsd";
        InputStream POXsd = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        String xmltext = TestUtils.convertStreamToString(POXsd);
        POXsd.close();
        request.header("Slug", (Object)artifactFileName);
        request.body("application/xml", (Object)xmltext);
        ClientResponse response = request.post(Entry.class);
        Entry entry = (Entry)response.getEntity();
        Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
        Artifact artifact = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
        Assert.assertEquals((Object)2376L, (Object)artifact.getXsdDocument().getContentSize());
        Assert.assertEquals((Object)artifactFileName, (Object)artifact.getXsdDocument().getName());
        return entry;
    }

    private Entry doGetXsdEntry(URI entryId) throws Exception {
        String uuid = entryId.toString();
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid)));
        ClientResponse response = request.get(Entry.class);
        Entry entry = (Entry)response.getEntity();
        Artifact artifact = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
        Assert.assertNotNull((Object)artifact.getXsdDocument());
        Assert.assertEquals((Object)2376L, (Object)artifact.getXsdDocument().getContentSize());
        return entry;
    }

    private String doGetXsdContent(URI entryId) throws Exception {
        String uuid = entryId.toString();
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid + "/media")));
        ClientResponse response = request.get(String.class);
        return (String)response.getEntity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyXsdContent(String content) throws IOException {
        Assert.assertNotNull((Object)content);
        String artifactFileName = "PO.xsd";
        InputStream POXsd = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
        try {
            String expectedContent = TestUtils.convertStreamToString(POXsd);
            Assert.assertEquals((Object)expectedContent, (Object)content);
        }
        finally {
            POXsd.close();
        }
    }

    private void doUpdateXsdEntry(Entry entry) throws Exception {
        XsdDocument xsdDocument = (XsdDocument)SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        String uuid = xsdDocument.getUuid();
        xsdDocument.setDescription("** Updated description! **");
        SrampModelUtils.setCustomProperty((BaseArtifactType)xsdDocument, (String)"my.property", (String)"Hello World");
        SrampModelUtils.addGenericRelationship((BaseArtifactType)xsdDocument, (String)"NoTargetRel", null);
        Artifact arty = new Artifact();
        arty.setXsdDocument(xsdDocument);
        entry.setAnyOtherJAXBObject((Object)arty);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid)));
        request.body("application/atom+xml;type=entry", (Object)entry);
        request.put(Void.class);
    }

    private void verifyEntryUpdated(Entry entry) throws Exception {
        Artifact srampArtifactWrapper = (Artifact)entry.getAnyOtherJAXBObject(Artifact.class, new Class[0]);
        XsdDocument xsdDocument = srampArtifactWrapper.getXsdDocument();
        Assert.assertEquals((Object)"** Updated description! **", (Object)xsdDocument.getDescription());
        Assert.assertEquals((Object)"Hello World", (Object)SrampModelUtils.getCustomProperty((BaseArtifactType)xsdDocument, (String)"my.property"));
        Assert.assertNull((Object)SrampModelUtils.getCustomProperty((BaseArtifactType)xsdDocument, (String)"my.missing.property"));
        Assert.assertNotNull((Object)SrampModelUtils.getGenericRelationship((BaseArtifactType)xsdDocument, (String)"NoTargetRel"));
        Assert.assertNull((Object)SrampModelUtils.getGenericRelationship((BaseArtifactType)xsdDocument, (String)"MissingRel"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateXsdContent(Entry entry) throws Exception {
        XsdDocument xsdDocument = (XsdDocument)SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        String uuid = xsdDocument.getUuid();
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid + "/media")));
        String artifactFileName = "PO-updated.xsd";
        InputStream xsdStream = null;
        try {
            xsdStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/" + artifactFileName);
            request.body("application/xml", (Object)xsdStream);
            request.put(Void.class);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(xsdStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)xsdStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyContentUpdated(String content) throws IOException {
        Assert.assertNotNull((Object)content);
        InputStream xsdStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/xsd/PO-updated.xsd");
        try {
            String expectedContent = TestUtils.convertStreamToString(xsdStream);
            Assert.assertEquals((Object)expectedContent, (Object)content);
        }
        finally {
            xsdStream.close();
        }
    }

    private void deleteXsdEntry(URI entryId) throws Exception {
        String uuid = entryId.toString();
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid)));
        request.delete(Void.class);
    }

    private void verifyEntryDeleted(URI entryId) throws Exception {
        String uuid = entryId.toString();
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/xsd/XsdDocument/" + uuid)));
        try {
            request.get(String.class);
            Assert.fail((String)"Expected an 'Artifact not found.' error here.");
        }
        catch (SrampAtomException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("No artifact found with UUID:"));
        }
    }
}

