/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services;

import java.net.URL;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.junit.Assert;
import org.junit.Test;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.client.ClientRequest;
import org.overlord.sramp.common.test.resteasy.TestPortProvider;
import org.overlord.sramp.server.atom.services.AbstractNoAuditingResourceTest;
import org.w3._1999._02._22_rdf_syntax_ns_.RDF;
import org.w3._2002._07.owl_.Class;
import org.w3._2002._07.owl_.Ontology;

public class OntologyResourceTest
extends AbstractNoAuditingResourceTest {
    @Test
    public void testCreate() throws Exception {
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/ontology"));
        RDF rdf = this.loadTestRDF("regional");
        request.body((javax.ws.rs.core.MediaType)MediaType.APPLICATION_RDF_XML_TYPE, (Object)rdf);
        ClientResponse response = request.post(Entry.class);
        Entry entry = (Entry)response.getEntity();
        RDF ontology = (RDF)SrampAtomUtils.unwrap((Entry)entry, RDF.class);
        Assert.assertNotNull((Object)ontology);
        this.assertEquals(rdf, ontology);
    }

    @Test
    public void testGet() throws Exception {
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/ontology"));
        RDF rdf = this.loadTestRDF("regional");
        request.body((javax.ws.rs.core.MediaType)MediaType.APPLICATION_RDF_XML_TYPE, (Object)rdf);
        ClientResponse response = request.post(Entry.class);
        Entry entry = (Entry)response.getEntity();
        String uuid = entry.getId().toString();
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/ontology/" + uuid)));
        entry = (Entry)request.get(Entry.class).getEntity();
        RDF ontology = (RDF)SrampAtomUtils.unwrap((Entry)entry, RDF.class);
        Assert.assertNotNull((Object)ontology);
        this.assertEquals(rdf, ontology);
    }

    @Test
    public void testFeed() throws Exception {
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/ontology"));
        RDF rdf = this.loadTestRDF("regional");
        request.body((javax.ws.rs.core.MediaType)MediaType.APPLICATION_RDF_XML_TYPE, (Object)rdf);
        request.post(Entry.class).getEntity();
        request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/ontology"));
        rdf = this.loadTestRDF("colors");
        request.body((javax.ws.rs.core.MediaType)MediaType.APPLICATION_RDF_XML_TYPE, (Object)rdf);
        request.post(Entry.class).getEntity();
        request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/ontology"));
        Feed feed = (Feed)request.get(Feed.class).getEntity();
        Assert.assertNotNull((Object)feed);
        Assert.assertEquals((long)2L, (long)feed.getEntries().size());
    }

    private void assertEquals(RDF expected, RDF actual) {
        Assert.assertNotNull((Object)expected);
        Assert.assertNotNull((Object)actual);
        Ontology expectedOntology = expected.getOntology();
        Ontology actualOntology = actual.getOntology();
        Assert.assertNotNull((Object)expectedOntology);
        Assert.assertNotNull((Object)actualOntology);
        Object expectedBase = null;
        Object actualBase = null;
        Assert.assertEquals(expectedBase, actualBase);
        Assert.assertEquals((Object)expectedOntology.getID(), (Object)actualOntology.getID());
        Assert.assertEquals((Object)expectedOntology.getLabel(), (Object)actualOntology.getLabel());
        Assert.assertEquals((Object)expectedOntology.getComment(), (Object)actualOntology.getComment());
        List expectedClasses = expected.getClazz();
        List actualClasses = actual.getClazz();
        Assert.assertEquals((long)expectedClasses.size(), (long)actualClasses.size());
        for (int idx = 0; idx < expectedClasses.size(); ++idx) {
            Class expectedClass = (Class)expectedClasses.get(idx);
            Class actualClass = (Class)actualClasses.get(idx);
            this.assertEquals(expectedClass, actualClass);
        }
    }

    private void assertEquals(Class expectedClass, Class actualClass) {
        Assert.assertNotNull((Object)expectedClass);
        Assert.assertNotNull((Object)actualClass);
        Assert.assertEquals((Object)expectedClass.getID(), (Object)actualClass.getID());
        Assert.assertEquals((Object)expectedClass.getLabel(), (Object)actualClass.getLabel());
        Assert.assertEquals((Object)expectedClass.getComment(), (Object)actualClass.getComment());
        if (expectedClass.getSubClassOf() == null) {
            Assert.assertNull((Object)actualClass.getSubClassOf());
        } else {
            Assert.assertNotNull((Object)actualClass.getSubClassOf());
            Assert.assertEquals((Object)expectedClass.getSubClassOf().getResource(), (Object)actualClass.getSubClassOf().getResource());
        }
    }

    private RDF loadTestRDF(String testOwlName) throws Exception {
        URL resourceUrl = ((Object)((Object)this)).getClass().getResource("/ontology-files/" + testOwlName + ".owl.xml");
        Assert.assertNotNull((Object)resourceUrl);
        JAXBContext jaxbContext = JAXBContext.newInstance((java.lang.Class[])new java.lang.Class[]{RDF.class});
        Unmarshaller unMarshaller = jaxbContext.createUnmarshaller();
        return (RDF)unMarshaller.unmarshal(resourceUrl);
    }
}

