/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services;

import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.io.IOUtils;
import org.jboss.downloads.overlord.sramp._2013.auditing.AuditEntry;
import org.jboss.downloads.overlord.sramp._2013.auditing.AuditItemType;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Document;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.client.ClientRequest;
import org.overlord.sramp.common.audit.AuditUtils;
import org.overlord.sramp.common.test.resteasy.TestPortProvider;
import org.overlord.sramp.server.atom.services.AbstractAuditingResourceTest;

public class AuditResourceTest
extends AbstractAuditingResourceTest {
    @BeforeClass
    public static void enableAuditing() {
        System.setProperty("sramp.config.auditing.enabled", "true");
    }

    @Test
    public void testListAndGet() throws Exception {
        Document pdf = this.addPdf();
        this.addPdf();
        Thread.sleep(1000L);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/audit/artifact/" + pdf.getUuid())));
        Feed auditEntryFeed = (Feed)request.get(Feed.class).getEntity();
        Assert.assertNotNull((Object)auditEntryFeed);
        List entries = auditEntryFeed.getEntries();
        Assert.assertEquals((long)1L, (long)entries.size());
        String auditEntryUuid = null;
        for (Entry entry : entries) {
            auditEntryUuid = entry.getId().toString();
        }
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/audit/artifact/" + pdf.getUuid() + "/" + auditEntryUuid)));
        Entry entry = (Entry)request.get(Entry.class).getEntity();
        AuditEntry auditEntry = (AuditEntry)SrampAtomUtils.unwrap((Entry)entry, AuditEntry.class);
        Assert.assertNotNull((Object)auditEntry);
        Assert.assertEquals((Object)"junituser", (Object)auditEntry.getWho());
        Assert.assertEquals((Object)"artifact:add", (Object)auditEntry.getType());
        List auditItems = auditEntry.getAuditItem();
        Assert.assertEquals((long)1L, (long)auditItems.size());
        Assert.assertNotNull((Object)auditItems);
        AuditItemType auditItem = AuditUtils.getAuditItem((AuditEntry)auditEntry, (String)"property:added");
        Assert.assertNotNull((Object)auditItem);
        Assert.assertEquals((Object)"property:added", (Object)auditItem.getType());
        List properties = auditItem.getProperty();
        for (AuditItemType.Property property : properties) {
            Assert.assertNotNull((Object)property);
            String name = property.getName();
            String value = property.getValue();
            if (name.equals("sramp:name")) {
                Assert.assertEquals((Object)"sample.pdf", (Object)value);
                continue;
            }
            if (name.equals("sramp:contentSize")) {
                Assert.assertEquals((Object)"218882", (Object)value);
                continue;
            }
            if (name.equals("sramp:contentHash")) {
                Assert.assertEquals((Object)"12e5f2da18960dc085ca27bec1ae9e3245389cb1", (Object)value);
                continue;
            }
            if (name.equals("sramp:contentType")) {
                Assert.assertEquals((Object)"application/pdf", (Object)value);
                continue;
            }
            Assert.fail((String)("No assertion for audited property: " + name));
        }
        request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/audit/user/junituser"));
        auditEntryFeed = (Feed)request.get(Feed.class).getEntity();
        Assert.assertNotNull((Object)auditEntryFeed);
        entries = auditEntryFeed.getEntries();
        Assert.assertEquals((long)2L, (long)entries.size());
    }

    @Test
    public void testCreate() throws Exception {
        Document pdf = this.addPdf();
        Thread.sleep(1000L);
        DatatypeFactory dtFactory = DatatypeFactory.newInstance();
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/audit/artifact/" + pdf.getUuid())));
        XMLGregorianCalendar now = dtFactory.newXMLGregorianCalendar((GregorianCalendar)Calendar.getInstance());
        AuditEntry auditEntry = new AuditEntry();
        auditEntry.setType("junit:test1");
        auditEntry.setWhen(now);
        auditEntry.setWho("junituser");
        AuditItemType item = AuditUtils.getOrCreateAuditItem((AuditEntry)auditEntry, (String)"junit:item");
        AuditUtils.setAuditItemProperty((AuditItemType)item, (String)"foo", (String)"bar");
        AuditUtils.setAuditItemProperty((AuditItemType)item, (String)"hello", (String)"world");
        request.body((javax.ws.rs.core.MediaType)MediaType.APPLICATION_AUDIT_ENTRY_XML_TYPE, (Object)auditEntry);
        ClientResponse response = request.post(Entry.class);
        Entry entry = (Entry)response.getEntity();
        AuditEntry re = (AuditEntry)SrampAtomUtils.unwrap((Entry)entry, AuditEntry.class);
        Assert.assertNotNull((Object)re);
        Assert.assertNotNull((Object)re.getUuid());
        Assert.assertEquals((Object)"junituser", (Object)re.getWho());
        Assert.assertEquals((long)1L, (long)re.getAuditItem().size());
        Assert.assertEquals((Object)"junit:item", (Object)((AuditItemType)re.getAuditItem().iterator().next()).getType());
        Assert.assertEquals((long)2L, (long)((AuditItemType)re.getAuditItem().iterator().next()).getProperty().size());
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/audit/artifact/" + pdf.getUuid())));
        Feed auditEntryFeed = (Feed)request.get(Feed.class).getEntity();
        Assert.assertNotNull((Object)auditEntryFeed);
        List entries = auditEntryFeed.getEntries();
        Assert.assertEquals((long)2L, (long)entries.size());
        request = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/audit/artifact/" + pdf.getUuid() + "/" + re.getUuid())));
        response = request.get(Entry.class);
        entry = (Entry)response.getEntity();
        re = (AuditEntry)SrampAtomUtils.unwrap((Entry)entry, AuditEntry.class);
        Assert.assertNotNull((Object)re);
        Assert.assertNotNull((Object)re.getUuid());
        Assert.assertEquals((Object)"junituser", (Object)re.getWho());
        Assert.assertEquals((long)1L, (long)re.getAuditItem().size());
        Assert.assertEquals((Object)"junit:item", (Object)((AuditItemType)re.getAuditItem().iterator().next()).getType());
        Assert.assertEquals((long)2L, (long)((AuditItemType)re.getAuditItem().iterator().next()).getProperty().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document addPdf() throws Exception {
        String artifactFileName = "sample.pdf";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/sample-files/core/" + artifactFileName);
        try {
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/core/Document"));
            request.header("Slug", (Object)artifactFileName);
            request.body("application/pdf", (Object)contentStream);
            ClientResponse response = request.post(Entry.class);
            Entry entry = (Entry)response.getEntity();
            Assert.assertEquals((Object)artifactFileName, (Object)entry.getTitle());
            BaseArtifactType arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
            Assert.assertTrue((boolean)(arty instanceof Document));
            Document document = (Document)arty;
            return document;
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }
}

