/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services.brms;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import org.apache.commons.io.IOUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedOutput;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Artifact;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.BaseArtifactType;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.ExtendedDocument;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.Property;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.client.ClientRequest;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.atom.services.brms.assets.Assets;
import org.overlord.sramp.atom.services.brms.packages.Packages;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.test.resteasy.TestPortProvider;
import org.overlord.sramp.server.atom.services.AbstractNoAuditingResourceTest;
import org.overlord.sramp.server.atom.services.brms.BrmsResource;
import test.org.overlord.sramp.server.TestUtils;

public class BrmsResourceTest
extends AbstractNoAuditingResourceTest {
    @BeforeClass
    public static void setUpBrms() throws Exception {
        dispatcher.getRegistry().addPerRequestResource(BrmsResource.class);
    }

    @Test
    public void testNoSuchPackage() {
        try {
            ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/brms/rest/packages/srampPackage/binary"));
            ClientResponse response = request.get(InputStream.class);
            Assert.fail((String)"Expecting to find no such package.");
        }
        catch (Exception e) {
            Assert.assertEquals(e.getClass(), SrampAtomException.class);
        }
    }

    @Test
    public void testBrmsPackages() throws Exception {
        String artifactFileName = "srampPackage.pkg";
        InputStream contentStream = ((Object)((Object)this)).getClass().getResourceAsStream("/brms/srampPackage/" + artifactFileName);
        ClientRequest request = new ClientRequest(TestPortProvider.generateURL((String)"/s-ramp/ext/BrmsPkgDocument"));
        request.header("Slug", (Object)artifactFileName);
        request.body("application/octet-stream", (Object)contentStream);
        ClientResponse response = request.post(Entry.class);
        Entry entry = (Entry)response.getEntity();
        BaseArtifactType arty = SrampAtomUtils.unwrapSrampArtifact((Entry)entry);
        ClientRequest request1 = new ClientRequest(TestPortProvider.generateURL((String)"/brms/rest/packages/srampPackage/binary"));
        ClientResponse response1 = request1.get(InputStream.class);
        if (response1.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response1.getStatus());
        }
        InputStream in = (InputStream)response1.getEntity();
        File file = new File("target/SRAMP-srampPackage.pkg");
        FileOutputStream out = new FileOutputStream(file);
        IOUtils.copy((InputStream)in, (OutputStream)out);
        out.flush();
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        ClientRequest request2 = new ClientRequest(TestPortProvider.generateURL((String)"/brms/rest/packages"));
        ClientResponse response2 = request2.get(Packages.class);
        Packages packages = (Packages)response2.getEntity();
        Assert.assertEquals((long)1L, (long)packages.getPackage().size());
        Assert.assertEquals((Object)"srampPackage", (Object)((Packages.Package)packages.getPackage().get(0)).getTitle());
        Assert.assertTrue((boolean)(arty instanceof ExtendedDocument));
        ExtendedDocument brmsPkgDocument = (ExtendedDocument)arty;
        Property assetsProperty = new Property();
        assetsProperty.setPropertyName("AssetInfoXML");
        InputStream assetsInputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/brms/srampPackage/rest/assets.xml");
        String assetsXml = TestUtils.convertStreamToString(assetsInputStream);
        IOUtils.closeQuietly((InputStream)assetsInputStream);
        assetsXml = assetsXml.replaceAll("http://localhost:8080/drools-guvnor", "http://localhost:8080/s-ramp-server/brms");
        assetsProperty.setPropertyValue(assetsXml);
        brmsPkgDocument.getProperty().add(assetsProperty);
        Entry entry3 = new Entry();
        ClientRequest request3 = new ClientRequest(TestPortProvider.generateURL((String)("/s-ramp/ext/BrmsPkgDocument/" + brmsPkgDocument.getUuid())));
        Artifact artifact = new Artifact();
        artifact.setExtendedDocument(brmsPkgDocument);
        entry3.setAnyOtherJAXBObject((Object)artifact);
        request3.body("application/atom+xml;type=entry", (Object)entry3);
        request3.put(Void.class);
        ClientRequest request4 = new ClientRequest(TestPortProvider.generateURL((String)"/brms/rest/packages/srampPackage/assets"));
        ClientResponse response4 = request4.get(Assets.class);
        Assets assets = (Assets)response4.getEntity();
        Assert.assertEquals((long)8L, (long)assets.getAsset().size());
        for (Assets.Asset asset : assets.getAsset()) {
            String fileFormat = asset.getMetadata().getFormat().toLowerCase();
            if (fileFormat.equals("package")) continue;
            String fileName = asset.getTitle() + "." + asset.getMetadata().getFormat();
            String uuid = asset.getMetadata().getUuid();
            InputStream assetInputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/brms/srampPackage/" + fileName);
            ArtifactType artifactType = ArtifactType.fromFileExtension((String)asset.getMetadata().getFormat());
            BaseArtifactType baseArtifactType = artifactType.newArtifactInstance();
            baseArtifactType.setName(fileName);
            baseArtifactType.setUuid(uuid);
            String path = "/s-ramp/" + artifactType.getModel() + "/" + artifactType.getType();
            ClientRequest request5 = new ClientRequest(TestPortProvider.generateURL((String)path));
            MultipartRelatedOutput output = new MultipartRelatedOutput();
            Entry atomEntry = new Entry();
            MediaType mediaType = new MediaType("application", "atom+xml");
            artifact = new Artifact();
            String methodStr = "set" + artifactType.getArtifactType();
            Method method = artifact.getClass().getMethod(methodStr, artifactType.getArtifactType().getTypeClass());
            method.invoke((Object)artifact, baseArtifactType);
            atomEntry.setAnyOtherJAXBObject((Object)artifact);
            output.addPart((Object)atomEntry, (javax.ws.rs.core.MediaType)mediaType);
            MediaType mediaType2 = MediaType.getInstance((String)artifactType.getMimeType());
            output.addPart((Object)assetInputStream, (javax.ws.rs.core.MediaType)mediaType2);
            System.out.println("Uploading asset " + fileName + " " + artifactType);
            request5.body("multipart/related", (Object)output);
            ClientResponse assetResponse = request5.post(Entry.class);
            IOUtils.closeQuietly((InputStream)assetInputStream);
            Entry assetEntry = (Entry)assetResponse.getEntity();
            BaseArtifactType assetArtifact = SrampAtomUtils.unwrapSrampArtifact((Entry)assetEntry);
            System.out.println("Uploaded asset " + assetArtifact.getName() + " " + assetArtifact.getUuid());
        }
        ClientRequest request7 = new ClientRequest(TestPortProvider.generateURL((String)"/brms/rest/packages/srampPackage/assets/Evaluation/binary"));
        ClientResponse response7 = request7.get(InputStream.class);
        if (response1.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        InputStream in7 = (InputStream)response7.getEntity();
        File file7 = new File("target/SRAMP-Evaluation.bpmn");
        FileOutputStream out7 = new FileOutputStream(file7);
        IOUtils.copy((InputStream)in7, (OutputStream)out7);
        out7.flush();
        IOUtils.closeQuietly((InputStream)in7);
        IOUtils.closeQuietly((OutputStream)out7);
        Assert.assertTrue((boolean)file7.exists());
        long size = file7.length();
        Assert.assertTrue((size >= 12483L ? 1 : 0) != 0);
        ClientRequest request8 = new ClientRequest(TestPortProvider.generateURL((String)"/brms/rest/packages/srampPackage/assets/Evaluation-image/binary"));
        ClientResponse response8 = request8.get(InputStream.class);
        if (response1.getStatus() != 200) {
            throw new RuntimeException("Failed : HTTP error code : " + response.getStatus());
        }
        InputStream in8 = (InputStream)response8.getEntity();
        File file8 = new File("target/SRAMP-Evaluation-image.png");
        FileOutputStream out8 = new FileOutputStream(file8);
        IOUtils.copy((InputStream)in8, (OutputStream)out8);
        out8.flush();
        IOUtils.closeQuietly((InputStream)in8);
        IOUtils.closeQuietly((OutputStream)out8);
        Assert.assertTrue((boolean)file8.exists());
        Assert.assertEquals((long)14029L, (long)file8.length());
    }
}

