/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.mime;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.tika.Tika;
import org.overlord.sramp.common.ArtifactType;
import org.overlord.sramp.common.ArtifactTypeEnum;

public class MimeTypes {
    private static final Tika tika = new Tika();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentType(File file) {
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            String string = MimeTypes.getContentType(file.getName(), is);
            IOUtils.closeQuietly((InputStream)is);
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    public static String getContentType(String name, InputStream stream) {
        try {
            return tika.detect(stream, name);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String determineMimeType(String fileName, InputStream stream, ArtifactType artifactType) {
        if (artifactType.getArtifactType() == ArtifactTypeEnum.Document || artifactType.getArtifactType() == ArtifactTypeEnum.ExtendedDocument) {
            String ct = MimeTypes.getContentType(fileName, stream);
            return ct == null ? "application/octet-stream" : ct;
        }
        return "application/xml";
    }
}

