/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services.brms;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Scanner;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.junit.Assert;
import org.junit.Test;
import org.overlord.sramp.atom.services.brms.Format;
import org.overlord.sramp.atom.services.brms.assets.Assets;
import org.overlord.sramp.atom.services.brms.packages.Packages;

public class BrmsPackagesListTest {
    @Test
    public void marshallPackageXml() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.overlord.sramp.atom.services.brms");
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            Packages packages = new Packages();
            Packages.Package _package = new Packages.Package();
            _package.setAuthor("kurt");
            _package.getAssets().add("http://localhost:8080/drools-guvnor/rest/packages/defaultPackage/assets/Test");
            packages.getPackage().add(_package);
            StringWriter writer = new StringWriter();
            JAXBElement element = new JAXBElement(new QName("", "collection", ""), Packages.class, (Object)packages);
            marshaller.marshal((Object)element, (Writer)writer);
            String actualXml = writer.toString();
            System.out.println(actualXml);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"No exception should be thrown");
        }
    }

    @Test
    public void unmarshallPackagesXml() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.overlord.sramp.atom.services.brms");
            Unmarshaller unMarshaller = jaxbContext.createUnmarshaller();
            Assert.assertNotNull((String)"Cannot locate file packages.xml", (Object)this.getClass().getResourceAsStream("/brms/srampPackage/rest/packages.xml"));
            String packagesXML = new Scanner(this.getClass().getResourceAsStream("/brms/srampPackage/rest/packages.xml")).useDelimiter("\\Z").next();
            StringReader reader = new StringReader(packagesXML);
            JAXBElement element = unMarshaller.unmarshal((Source)new StreamSource(reader), Packages.class);
            Packages packages = (Packages)element.getValue();
            Assert.assertEquals((long)1L, (long)packages.getPackage().size());
        }
        catch (JAXBException jaxbe) {
            jaxbe.printStackTrace();
            Assert.fail((String)"No exception should be thrown");
        }
    }

    @Test
    public void marshallAssetsXml() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.overlord.sramp.atom.services.brms");
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            Assets assets = new Assets();
            Assets.Asset asset = new Assets.Asset();
            asset.setTitle("myAsset");
            assets.getAsset().add(asset);
            StringWriter writer = new StringWriter();
            JAXBElement element = new JAXBElement(new QName("", "collection", ""), Assets.class, (Object)assets);
            marshaller.marshal((Object)element, (Writer)writer);
            String actualXml = writer.toString();
            System.out.println(actualXml);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"No exception should be thrown");
        }
    }

    @Test
    public void unmarshallAssetsXml() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.overlord.sramp.atom.services.brms");
            Unmarshaller unMarshaller = jaxbContext.createUnmarshaller();
            Assert.assertNotNull((String)"Cannot locate file packages.xml", (Object)this.getClass().getResourceAsStream("/brms/srampPackage/rest/assets.xml"));
            String assetsXML = new Scanner(this.getClass().getResourceAsStream("/brms/srampPackage/rest/assets.xml")).useDelimiter("\\Z").next();
            StringReader reader = new StringReader(assetsXML);
            JAXBElement element = unMarshaller.unmarshal((Source)new StreamSource(reader), Assets.class);
            Assets assets = (Assets)element.getValue();
            Assert.assertEquals((long)8L, (long)assets.getAsset().size());
        }
        catch (JAXBException jaxbe) {
            jaxbe.printStackTrace();
            Assert.fail((String)"No exception should be thrown");
        }
    }

    @Test
    public void marshallFormatXml() {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((String)"org.overlord.sramp.atom.services.brms");
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.FALSE);
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            Format format = new Format();
            format.setValue("ftl");
            StringWriter writer = new StringWriter();
            JAXBElement element = new JAXBElement(new QName("", "format", ""), Format.class, (Object)format);
            marshaller.marshal((Object)element, (Writer)writer);
            String actualXml = writer.toString();
            System.out.println(actualXml);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"No exception should be thrown");
        }
    }
}

