/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.services;

import java.net.URI;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.jboss.resteasy.plugins.providers.atom.Entry;
import org.jboss.resteasy.plugins.providers.atom.Feed;
import org.jboss.resteasy.plugins.providers.atom.Link;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;
import org.overlord.sramp.atom.MediaType;
import org.overlord.sramp.atom.SrampAtomUtils;
import org.overlord.sramp.atom.err.SrampAtomException;
import org.overlord.sramp.common.SrampConfig;
import org.overlord.sramp.common.SrampException;
import org.overlord.sramp.common.storedquery.StoredQueryAlreadyExistsException;
import org.overlord.sramp.common.storedquery.StoredQueryNotFoundException;
import org.overlord.sramp.repository.PersistenceFactory;
import org.overlord.sramp.repository.PersistenceManager;
import org.overlord.sramp.server.atom.services.AbstractFeedResource;
import org.overlord.sramp.server.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/s-ramp/query")
public class StoredQueryResource
extends AbstractFeedResource {
    private static Logger logger = LoggerFactory.getLogger(StoredQueryResource.class);

    @POST
    @Consumes(value={"application/atom+xml;type=entry"})
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry create(@Context HttpServletRequest request, Entry atomEntry) throws SrampAtomException, SrampException {
        try {
            String baseUrl = SrampConfig.getBaseUrl((String)request.getRequestURL().toString());
            StoredQuery storedQuery = SrampAtomUtils.unwrapStoredQuery((Entry)atomEntry);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            storedQuery = persistenceManager.persistStoredQuery(storedQuery);
            return this.wrapStoredQuery(storedQuery, baseUrl);
        }
        catch (StoredQueryAlreadyExistsException e) {
            throw e;
        }
        catch (Exception e) {
            StoredQueryResource.logError(logger, Messages.i18n.format("ERROR_CREATING_STOREDQUERY", new Object[0]), e);
            throw new SrampAtomException((Throwable)e);
        }
    }

    @PUT
    @Path(value="{queryName}")
    @Consumes(value={"application/atom+xml;type=entry"})
    public void update(@PathParam(value="queryName") String queryName, Entry atomEntry) throws SrampAtomException, SrampException {
        try {
            StoredQuery storedQuery = SrampAtomUtils.unwrapStoredQuery((Entry)atomEntry);
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            persistenceManager.updateStoredQuery(queryName, storedQuery);
        }
        catch (StoredQueryNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            StoredQueryResource.logError(logger, Messages.i18n.format("ERROR_UPDATING_STOREDQUERY", new Object[]{queryName}), e);
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Path(value="{queryName}")
    @Produces(value={"application/atom+xml;type=entry"})
    public Entry get(@Context HttpServletRequest request, @PathParam(value="queryName") String queryName) throws SrampAtomException, SrampException {
        try {
            String baseUrl = SrampConfig.getBaseUrl((String)request.getRequestURL().toString());
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            StoredQuery storedQuery = persistenceManager.getStoredQuery(queryName);
            return this.wrapStoredQuery(storedQuery, baseUrl);
        }
        catch (StoredQueryNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            StoredQueryResource.logError(logger, Messages.i18n.format("ERROR_GETTING_STOREDQUERY", new Object[]{queryName}), e);
            throw new SrampAtomException(e);
        }
    }

    @GET
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed list(@Context HttpServletRequest request) throws SrampAtomException {
        try {
            String baseUrl = SrampConfig.getBaseUrl((String)request.getRequestURL().toString());
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            List storedQueries = persistenceManager.getStoredQueries();
            Feed feed = new Feed();
            feed.setTitle("S-RAMP stored queries feed");
            feed.setUpdated(new Date());
            for (StoredQuery storedQuery : storedQueries) {
                feed.getEntries().add(this.wrapStoredQuery(storedQuery, baseUrl));
            }
            return feed;
        }
        catch (Exception e) {
            StoredQueryResource.logError(logger, Messages.i18n.format("ERROR_GETTING_STOREDQUERIES", new Object[0]), e);
            throw new SrampAtomException((Throwable)e);
        }
    }

    @GET
    @Path(value="{queryName}/results")
    @Produces(value={"application/atom+xml;type=feed"})
    public Feed getResults(@Context HttpServletRequest request, @PathParam(value="queryName") String queryName, @QueryParam(value="startPage") Integer startPage, @QueryParam(value="startIndex") Integer startIndex, @QueryParam(value="count") Integer count, @QueryParam(value="orderBy") String orderBy, @QueryParam(value="ascending") Boolean asc) throws SrampAtomException, SrampException {
        try {
            String baseUrl = SrampConfig.getBaseUrl((String)request.getRequestURL().toString());
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            StoredQuery storedQuery = persistenceManager.getStoredQuery(queryName);
            return this.createArtifactFeed(storedQuery.getQueryExpression(), startIndex, count, orderBy, asc, new HashSet<String>(storedQuery.getPropertyName()), baseUrl);
        }
        catch (StoredQueryNotFoundException e) {
            throw e;
        }
        catch (SrampAtomException e) {
            throw e;
        }
        catch (Throwable e) {
            StoredQueryResource.logError(logger, Messages.i18n.format("ERROR_EXECUTING_STOREDQUERY", new Object[]{queryName}), e);
            throw new SrampAtomException(e);
        }
    }

    @DELETE
    @Path(value="{queryName}")
    public void delete(@PathParam(value="queryName") String queryName) throws SrampAtomException, SrampException {
        try {
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            persistenceManager.deleteStoredQuery(queryName);
        }
        catch (StoredQueryNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            StoredQueryResource.logError(logger, Messages.i18n.format("ERROR_DELETING_STOREDQUERY", new Object[]{queryName}), e);
            throw new SrampAtomException(e);
        }
    }

    private Entry wrapStoredQuery(StoredQuery storedQuery, String baseUrl) throws Exception {
        Entry entry = SrampAtomUtils.wrapStoredQuery((StoredQuery)storedQuery);
        String atomLink = baseUrl + "/s-ramp/query/" + storedQuery.getQueryName();
        Link linkToSelf = new Link();
        linkToSelf.setType((javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_ENTRY_TYPE);
        linkToSelf.setRel("self");
        linkToSelf.setHref(new URI(atomLink));
        entry.getLinks().add(linkToSelf);
        Link linkToEdit = new Link();
        linkToEdit.setType((javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_ENTRY_TYPE);
        linkToEdit.setRel("edit");
        linkToEdit.setHref(new URI(atomLink));
        entry.getLinks().add(linkToEdit);
        Link linkToResults = new Link();
        linkToResults.setType((javax.ws.rs.core.MediaType)MediaType.APPLICATION_ATOM_XML_FEED_TYPE);
        linkToResults.setRel("urn:x-s-ramp:2013:query:results");
        linkToResults.setHref(new URI(atomLink + "/results"));
        entry.getLinks().add(linkToResults);
        return entry;
    }
}

