/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.server.atom.workspaces;

import java.util.List;
import org.jboss.resteasy.plugins.providers.atom.app.AppCollection;
import org.oasis_open.docs.s_ramp.ns.s_ramp_v1.StoredQuery;
import org.overlord.sramp.common.SrampException;
import org.overlord.sramp.repository.PersistenceFactory;
import org.overlord.sramp.repository.PersistenceManager;
import org.overlord.sramp.server.atom.workspaces.AbstractWorkspace;
import org.overlord.sramp.server.i18n.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredQueryWorkspace
extends AbstractWorkspace {
    private static final long serialVersionUID = 9119601241133543724L;
    private static Logger LOGGER = LoggerFactory.getLogger(StoredQueryWorkspace.class);

    public StoredQueryWorkspace(String hrefBase) {
        super(hrefBase, "Query Model");
    }

    @Override
    protected void configureWorkspace() {
        AppCollection collection = this.addCollection("/s-ramp/query", "Query Model", "application/zip");
        this.addCategory(collection, "query", "StoredQuery");
        try {
            PersistenceManager persistenceManager = PersistenceFactory.newInstance();
            List storedQueries = persistenceManager.getStoredQueries();
            for (StoredQuery storedQuery : storedQueries) {
                AppCollection queryCollection = this.addCollection("/s-ramp/query/" + storedQuery.getQueryName(), storedQuery.getQueryName(), "");
                this.addCategory(queryCollection, "query", "StoredQuery");
            }
        }
        catch (SrampException e) {
            LOGGER.error(Messages.i18n.format("ERROR_GETTING_STOREDQUERIES", new Object[0]), (Throwable)e);
        }
    }
}

