/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.api;

import java.util.ArrayList;
import javax.xml.namespace.QName;

public class Arguments
extends ArrayList<String> {
    private static final long serialVersionUID = 4475521615147664784L;

    public Arguments(String arguments) {
        this.parseArguments(arguments);
    }

    private void parseArguments(String arguments) {
        ScannerState state = ScannerState.scanningForStart;
        char quotChar = '\'';
        int startPos = -1;
        int endPos = -1;
        for (int position = 0; position < arguments.length(); ++position) {
            char c = arguments.charAt(position);
            if (state == ScannerState.scanningForStart) {
                if (c == '\"' || c == '\'') {
                    startPos = position;
                    state = ScannerState.scanningForEndQuote;
                    quotChar = c;
                    continue;
                }
                if (Character.isWhitespace(c)) continue;
                startPos = position;
                state = ScannerState.scanningForEnd;
                continue;
            }
            if (state == ScannerState.scanningForEnd) {
                if (!Character.isWhitespace(c)) continue;
                endPos = position;
                this.add(arguments.substring(startPos, endPos));
                state = ScannerState.scanningForStart;
                continue;
            }
            if (state != ScannerState.scanningForEndQuote || c != quotChar) continue;
            endPos = position;
            this.add(arguments.substring(startPos + 1, endPos));
            state = ScannerState.scanningForStart;
        }
        if (state == ScannerState.scanningForEnd) {
            this.add(arguments.substring(startPos));
        }
    }

    public QName removeCommandName() {
        if (this.isEmpty()) {
            return null;
        }
        String encodedCommandName = (String)this.remove(0);
        QName commandName = null;
        if (encodedCommandName != null) {
            if (encodedCommandName.contains(":") && !encodedCommandName.endsWith(":")) {
                String[] nameSplit = encodedCommandName.split(":");
                commandName = new QName(nameSplit[0], nameSplit[1]);
            } else {
                commandName = new QName("s-ramp", encodedCommandName);
            }
        }
        return commandName;
    }

    private static enum ScannerState {
        scanningForStart,
        scanningForEnd,
        scanningForEndQuote;

    }
}

