/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.api;

import org.junit.Assert;
import org.junit.Test;
import org.overlord.sramp.shell.api.Arguments;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;

public class ArgumentsTest {
    private static String[][] TEST_DATA = new String[][]{{""}, {"s-ramp:connect", "s-ramp:connect"}, {"s-ramp:connect http://localhost:8080", "s-ramp:connect", "http://localhost:8080"}, {"cmd arg1 arg2 arg3 arg4", "cmd", "arg1", "arg2", "arg3", "arg4"}, {"cmd arg1 'arg2'", "cmd", "arg1", "arg2"}, {"cmd arg1 \"arg2\"", "cmd", "arg1", "arg2"}, {"cmd arg1 \"This is argument 2\"", "cmd", "arg1", "This is argument 2"}, {"cmd arg1 'This is argument 2'", "cmd", "arg1", "This is argument 2"}, {"cmd 'This is argument 1'", "cmd", "This is argument 1"}, {"cmd 'This is argument 1' ''", "cmd", "This is argument 1", ""}, {"cmd 'quote \" within quote'", "cmd", "quote \" within quote"}, {"cmd \"quote ' within quote\"", "cmd", "quote ' within quote"}};

    @Test
    public void testArguments() throws Exception {
        for (String[] testCaseData : TEST_DATA) {
            String argumentsLine = testCaseData[0];
            Arguments arguments = new Arguments(argumentsLine);
            Assert.assertEquals((long)(testCaseData.length - 1), (long)arguments.size());
            for (int idx = 0; idx < arguments.size(); ++idx) {
                String expected = testCaseData[idx + 1];
                String actual = (String)arguments.get(idx);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
        }
        Arguments arguments = null;
        try {
            arguments = new Arguments("query \"partial quoted arg");
            Assert.fail((String)"Expected an InvalidCommandArgumentException here.");
        }
        catch (InvalidCommandArgumentException e) {
            Assert.assertEquals((Object)"Invalid final argument - did you forget to close your quotes?", (Object)e.getMessage());
        }
        arguments = new Arguments("query \"partial quoted arg", true);
        Assert.assertEquals((long)2L, (long)arguments.size());
    }
}

