/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands;

import org.junit.Assert;
import org.junit.Test;
import org.overlord.sramp.shell.api.Arguments;

public class ArgumentsTest {
    private static String[][] TEST_DATA = new String[][]{{""}, {"s-ramp:connect", "s-ramp:connect"}, {"s-ramp:connect http://localhost:8080", "s-ramp:connect", "http://localhost:8080"}, {"cmd arg1 arg2 arg3 arg4", "cmd", "arg1", "arg2", "arg3", "arg4"}, {"cmd arg1 'arg2'", "cmd", "arg1", "arg2"}, {"cmd arg1 \"arg2\"", "cmd", "arg1", "arg2"}, {"cmd arg1 \"This is argument 2\"", "cmd", "arg1", "This is argument 2"}, {"cmd arg1 'This is argument 2'", "cmd", "arg1", "This is argument 2"}, {"cmd 'This is argument 1'", "cmd", "This is argument 1"}, {"cmd 'This is argument 1' ''", "cmd", "This is argument 1", ""}, {"cmd 'argument", "cmd"}, {"cmd 'quote \" within quote'", "cmd", "quote \" within quote"}, {"cmd \"quote ' within quote\"", "cmd", "quote ' within quote"}};

    @Test
    public void testArguments() {
        for (String[] testCaseData : TEST_DATA) {
            String argumentsLine = testCaseData[0];
            Arguments arguments = new Arguments(argumentsLine);
            Assert.assertEquals((long)(testCaseData.length - 1), (long)arguments.size());
            for (int idx = 0; idx < arguments.size(); ++idx) {
                String expected = testCaseData[idx + 1];
                String actual = (String)arguments.get(idx);
                Assert.assertEquals((Object)expected, (Object)actual);
            }
        }
    }
}

