/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.io.IOException;
import org.overlord.sramp.shell.AbstractShellCommandReader;
import org.overlord.sramp.shell.ConsoleShellCommandReader;
import org.overlord.sramp.shell.FileShellCommandReader;
import org.overlord.sramp.shell.InteractiveShellCommandReader;
import org.overlord.sramp.shell.ShellCommandFactory;
import org.overlord.sramp.shell.ShellCommandReader;
import org.overlord.sramp.shell.ShellContextImpl;
import org.overlord.sramp.shell.StdInShellCommandReader;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.api.ShellCommand;

public class SrampShell {
    private ShellCommandFactory factory = new ShellCommandFactory();
    private ShellContextImpl context = new ShellContextImpl();
    private ShellCommandReader reader;

    public static void main(String[] args) {
        final SrampShell shell = new SrampShell();
        Thread shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                shell.shutdown();
            }
        });
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        try {
            shell.run(args);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.out.println("Exiting s-ramp shell due to an error.");
        }
    }

    public void run(String[] args) throws Exception {
        this.reader = this.createCommandReader(args);
        this.displayWelcomeMessage();
        boolean done = false;
        while (!done) {
            ShellCommand command = this.reader.read();
            try {
                if (command == null) {
                    done = true;
                    continue;
                }
                command.execute();
            }
            catch (InvalidCommandArgumentException e) {
                System.out.println("Invalid argument:  " + e.getMessage());
                System.out.print("Usage:  ");
                command.printUsage();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    protected ShellCommandReader createCommandReader(String[] args) throws IOException {
        AbstractShellCommandReader commandReader = null;
        if (args.length >= 2 && "-f".equals(args[0])) {
            String filePath = args[1];
            commandReader = new FileShellCommandReader(this.factory, this.context, filePath);
        } else {
            commandReader = args.length == 1 && "-simple".equals(args[0]) ? (System.console() != null ? new ConsoleShellCommandReader(this.factory, this.context) : new StdInShellCommandReader(this.factory, this.context)) : (System.console() != null ? new InteractiveShellCommandReader(this.factory, this.context) : new StdInShellCommandReader(this.factory, this.context));
        }
        commandReader.open();
        return commandReader;
    }

    public void shutdown() {
        System.out.print("S-RAMP shell shutting down...");
        try {
            this.reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.context.destroy();
        System.out.println("done.");
    }

    private void displayWelcomeMessage() {
        System.out.println("**********************************************************************\n           _____       ______  ___ ___  ________  \n          /  ___|      | ___ \\/ _ \\|  \\/  | ___ \\ \n          \\ `--. ______| |_/ / /_\\ \\ .  . | |_/ / \n           `--. \\______|    /|  _  | |\\/| |  __/  \n          /\\__/ /      | |\\ \\| | | | |  | | |     \n          \\____/       \\_| \\_\\_| |_|_|  |_|_|     \n                                                  \n  JBoss S-RAMP Kurt Stam and Eric Wittmann, Licensed under the\n  Apache License, V2.0, Copyright 2012\n**********************************************************************");
    }
}

