/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import javax.xml.namespace.QName;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.common.visitors.ArtifactVisitor;
import org.overlord.sramp.common.visitors.ArtifactVisitorHelper;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.util.PrintArtifactMetaDataVisitor;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class ListEntryArchiveCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("archive:listEntry <archivePath>", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'listEntry' command is used to display information about", new Object[0]);
        this.print("a single entry in the currently open S-RAMP archive.  The", new Object[0]);
        this.print("path within the archive must be specified.", new Object[0]);
    }

    public void execute() throws Exception {
        String archivePathArg = this.requiredArgument(0, "Please include an entry path (relative archive path).");
        QName varName = new QName("archive", "active-archive");
        SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
        if (archive == null) {
            this.print("No S-RAMP archive is currently open.", new Object[0]);
        } else {
            SrampArchiveEntry entry = archive.getEntry(archivePathArg);
            BaseArtifactType metaData = entry.getMetaData();
            this.print("Entry: " + archivePathArg, new Object[0]);
            this.print("-----", new Object[0]);
            PrintArtifactMetaDataVisitor visitor = new PrintArtifactMetaDataVisitor();
            ArtifactVisitorHelper.visitArtifact((ArtifactVisitor)visitor, (BaseArtifactType)metaData);
        }
    }
}

