/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.atom.archive.SrampArchiveEntry;
import org.overlord.sramp.common.SrampModelUtils;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.api.ShellContext;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class UpdateEntryArchiveCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("archive:updateEntry <archivePath> <subCommand> <subCommandArgs>", new Object[0]);
        this.print("\tSub-Commands", new Object[0]);
        this.print("\t------------", new Object[0]);
        this.print("\tsetContent <pathToFileContent>", new Object[0]);
        this.print("\tsetProperty <propertyName> <propertyValue>", new Object[0]);
        this.print("\tsetRelationship <relationshipType> <targetUUID>", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'updateEntry' command is used to modify entries in the", new Object[0]);
        this.print("currently open S-RAMP batch archive.  The path to the entry", new Object[0]);
        this.print("must be specified, along with details about how the entry is", new Object[0]);
        this.print("to be modified.", new Object[0]);
        this.print("", new Object[0]);
        this.print(" setContent: a sub-command that sets the file content on a ", new Object[0]);
        this.print("      particular entry", new Object[0]);
        this.print(" setProperty: a sub-command that sets a single custom S-RAMP", new Object[0]);
        this.print("      property on the entry", new Object[0]);
        this.print(" setRelationship: a sub-command that sets a single generic", new Object[0]);
        this.print("      S-RAMP relationship on the entry", new Object[0]);
    }

    public void execute() throws Exception {
        String archivePathArg = this.requiredArgument(0, "Please include an entry path (relative archive path).");
        String subCommandArg = this.requiredArgument(1, "Please specify a sub-command.");
        QName varName = new QName("archive", "active-archive");
        SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
        if (archive == null) {
            this.print("No S-RAMP archive is currently open.", new Object[0]);
        } else {
            if (!archive.containsEntry(archivePathArg)) {
                throw new InvalidCommandArgumentException(0, "Archive Entry not found: " + archivePathArg);
            }
            if ("setContent".equals(subCommandArg)) {
                this.executeSetContent(archive, archivePathArg, this.getContext());
            }
            if ("setProperty".equals(subCommandArg)) {
                this.executeSetProperty(archive, archivePathArg, this.getContext());
            }
            if ("setRelationship".equals(subCommandArg)) {
                this.executeSetRelationship(archive, archivePathArg, this.getContext());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSetContent(SrampArchive archive, String entryPath, ShellContext context) throws Exception {
        String pathToContentArg = this.requiredArgument(2, "Please specify a path to the content file.");
        File file = new File(pathToContentArg);
        if (!file.isFile()) {
            throw new InvalidCommandArgumentException(2, "File not found: " + pathToContentArg);
        }
        FileInputStream contentStream = null;
        try {
            contentStream = FileUtils.openInputStream((File)file);
            SrampArchiveEntry entry = archive.getEntry(entryPath);
            archive.updateEntry(entry, (InputStream)contentStream);
            this.print("Entry (content) successfully set.", new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((InputStream)contentStream);
        }
    }

    private void executeSetProperty(SrampArchive archive, String entryPath, ShellContext context) throws Exception {
        String propNameArg = this.requiredArgument(2, "Please specify the name of the property.");
        String propValArg = this.requiredArgument(3, "Please specify the property value.");
        SrampArchiveEntry entry = archive.getEntry(entryPath);
        BaseArtifactType metaData = entry.getMetaData();
        if ("name".equals(propNameArg)) {
            metaData.setName(propValArg);
        } else if ("description".equals(propNameArg)) {
            metaData.setDescription(propValArg);
        } else if ("version".equals(propNameArg)) {
            metaData.setVersion(propValArg);
        } else if ("createdBy".equals(propNameArg)) {
            metaData.setCreatedBy(propValArg);
        } else if ("lastModifiedBy".equals(propNameArg)) {
            metaData.setLastModifiedBy(propValArg);
        } else if ("uuid".equals(propNameArg)) {
            metaData.setUuid(propValArg);
        } else if ("createdTimestamp".equals(propNameArg) || "lastModifiedTimestamp".equals(propNameArg)) {
            // empty if block
        }
        SrampModelUtils.setCustomProperty((BaseArtifactType)metaData, (String)propNameArg, (String)propValArg);
        archive.updateEntry(entry, null);
        this.print("Entry (meta-data) successfully set.", new Object[0]);
    }

    private void executeSetRelationship(SrampArchive archive, String entryPath, ShellContext context) throws Exception {
        throw new InvalidCommandArgumentException(0, "setRelationship sub-command not yet implemented.");
    }
}

