/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.overlord.sramp.client.SrampAtomApiClient;
import org.overlord.sramp.shell.api.AbstractShellCommand;
import org.overlord.sramp.shell.api.InvalidCommandArgumentException;
import org.overlord.sramp.shell.util.FileNameCompleter;
import org.s_ramp.xmlns._2010.s_ramp.BaseArtifactType;

public class UpdateContentCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("s-ramp:updateContent <filePathToContent>", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'updateContent' command updates the content of the currently active", new Object[0]);
        this.print("artifact in the context.  The new content is uploaded to the S-RAMP", new Object[0]);
        this.print("server.", new Object[0]);
        this.print("", new Object[0]);
        this.print("Example usage:", new Object[0]);
        this.print(">  s-ramp:updateContent /home/uname/files/new-content.wsdl", new Object[0]);
    }

    public void execute() throws Exception {
        String contentFilePathArg = this.requiredArgument(0, "Please supply a file path to the new content.");
        QName clientVarName = new QName("s-ramp", "client");
        QName artifactVarName = new QName("s-ramp", "artifact");
        SrampAtomApiClient client = (SrampAtomApiClient)this.getContext().getVariable(clientVarName);
        if (client == null) {
            this.print("No S-RAMP repository connection is currently open.", new Object[0]);
            return;
        }
        BaseArtifactType artifact = (BaseArtifactType)this.getContext().getVariable(artifactVarName);
        if (artifact == null) {
            this.print("No active S-RAMP artifact exists.  Use s-ramp:getMetaData.", new Object[0]);
            return;
        }
        File file = new File(contentFilePathArg);
        if (!file.isFile()) {
            throw new InvalidCommandArgumentException(0, "Please supply a path to a valid content file.");
        }
        FileInputStream content = null;
        try {
            content = FileUtils.openInputStream((File)file);
            client.updateArtifactContent(artifact, (InputStream)content);
            this.print("Successfully updated artifact %1$s.", new Object[]{artifact.getName()});
        }
        catch (Exception e) {
            this.print("FAILED to update the artifact.", new Object[0]);
            this.print("\t" + e.getMessage(), new Object[0]);
            IOUtils.closeQuietly((InputStream)content);
        }
    }

    public int tabCompletion(String lastArgument, List<CharSequence> candidates) {
        if (this.getArguments().isEmpty()) {
            if (lastArgument == null) {
                lastArgument = "";
            }
            FileNameCompleter delegate = new FileNameCompleter();
            return delegate.complete(lastArgument, lastArgument.length(), candidates);
        }
        return -1;
    }
}

