/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.overlord.sramp.shell.api.ShellContext;
import org.overlord.sramp.shell.api.ShellContextEventHandler;
import org.overlord.sramp.shell.api.ShellContextVariableLifecycleHandler;

public class ShellContextImpl
implements ShellContext {
    private Map<QName, Object> variables = new HashMap<QName, Object>();
    private Map<QName, ShellContextVariableLifecycleHandler> variableLifecycleHandlers = new HashMap<QName, ShellContextVariableLifecycleHandler>();
    private Set<ShellContextEventHandler> eventHandlers = new HashSet<ShellContextEventHandler>();

    public void setVariable(QName name, Object object) {
        boolean isUpdate = this.variables.containsKey(name);
        this.variables.put(name, object);
        if (isUpdate) {
            this.fireChangeEvent(name, object);
        } else {
            this.fireAddEvent(name, object);
        }
    }

    public void setVariable(QName name, Object object, ShellContextVariableLifecycleHandler lifecycleHandler) {
        if (lifecycleHandler.onAdd(object)) {
            this.setVariable(name, object);
            this.variableLifecycleHandlers.put(name, lifecycleHandler);
        }
    }

    public Object getVariable(QName name) {
        return this.variables.get(name);
    }

    public Object removeVariable(QName name) {
        if (!this.variables.containsKey(name)) {
            return null;
        }
        Object rval = this.variables.remove(name);
        ShellContextVariableLifecycleHandler handler = this.variableLifecycleHandlers.remove(name);
        if (handler != null) {
            handler.onRemove(rval);
        }
        this.fireRemoveEvent(name);
        return rval;
    }

    public void destroy() {
        for (QName varName : this.variables.keySet()) {
            Object object = this.variables.get(varName);
            ShellContextVariableLifecycleHandler handler = this.variableLifecycleHandlers.get(varName);
            if (handler == null) continue;
            handler.onContextDestroyed(object);
        }
    }

    public void addHandler(ShellContextEventHandler handler) {
        this.eventHandlers.add(handler);
    }

    public void removeHandler(ShellContextEventHandler handler) {
        this.eventHandlers.remove(handler);
    }

    private void fireAddEvent(QName name, Object object) {
        for (ShellContextEventHandler handler : this.eventHandlers) {
            handler.onVariableAdded(name, object);
        }
    }

    private void fireChangeEvent(QName name, Object object) {
        for (ShellContextEventHandler handler : this.eventHandlers) {
            handler.onVariableChanged(name, object);
        }
    }

    private void fireRemoveEvent(QName name) {
        for (ShellContextEventHandler handler : this.eventHandlers) {
            handler.onVariableRemoved(name);
        }
    }
}

