/*
 * Decompiled with CFR 0.152.
 */
package org.overlord.sramp.shell.commands.archive;

import java.io.File;
import javax.xml.namespace.QName;
import org.apache.commons.io.FileUtils;
import org.overlord.sramp.atom.archive.SrampArchive;
import org.overlord.sramp.shell.api.AbstractShellCommand;

public class PackArchiveCommand
extends AbstractShellCommand {
    public void printUsage() {
        this.print("archive:pack <outputLocation>", new Object[0]);
    }

    public void printHelp() {
        this.print("The 'pack' command packages up the currently open S-RAMP batch", new Object[0]);
        this.print("archive file.  The S-RAMP batch archive is zip'd up and then", new Object[0]);
        this.print("copied to the output file location provided.", new Object[0]);
    }

    public void execute() throws Exception {
        String outputLocationArg = this.requiredArgument(0, "Please include the output location (file path).");
        QName varName = new QName("archive", "active-archive");
        SrampArchive archive = (SrampArchive)this.getContext().getVariable(varName);
        if (archive == null) {
            this.print("No S-RAMP archive is currently open.", new Object[0]);
        } else {
            File outputFile = new File(outputLocationArg);
            if (outputFile.exists()) {
                this.print("Output location already exists!", new Object[0]);
            }
            if (!outputFile.getParentFile().exists()) {
                outputFile.mkdirs();
            }
            File packedFile = archive.pack();
            FileUtils.copyFile((File)packedFile, (File)outputFile);
            this.print("S-RAMP archive packaged and copied to: " + outputFile.getCanonicalPath(), new Object[0]);
        }
    }
}

